@extends('sculpt::layout')

@section('content')

    <h1><i class="fa fa-fw fa-file-text-o"></i> Case Story for #{{ $case->id }}</h1>

    @if($case->active_periods->count() == 0)
        <p>This case has not yet been opened. Case stories can only be generated for cases that have been opened and closed.</p>
    @else

        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    Case Summary
                </h3>
            </div>
            <div class="panel-body" style="padding: 5px 15px;">
                <div class="row">
                    <div class="col-sm-6">
                        <h4>Referral</h4>
                        <ul style="padding-left:20px;">
                            <li>Referred from <strong>{!! $case->referral_source ? $case->referral_source->name : "<span class='text-muted'>Not specified</span>" !!}</strong></li>
                            <li>Brief reason: {!! $case->brief_reason_for_referral ? "<em>{$case->brief_reason_for_referral}</em>" : "<strong><span class='text-muted'>Not specified</span></strong>" !!}</li>
                            <?php $first_active_period = $case->active_periods->first(); ?>
                                @if($first_active_period)
                                <li>
                                    Case opened on <strong>{{ $first_active_period->start->format('jS F Y') }}</strong>
                                    @if($first_active_period->activated_by)
                                        by <strong>{{ $first_active_period->activated_by->name }}</strong>
                                    @endif
                                </li>
                                @if($count = $case->service_user->cases->where('date','<',$case->date)->count())
                                    <li>This is this service user's {{ $count . ordinal_suffix($count + 1) }} case. <a href="{{ route('sculpt.show',['service-user-cases',$case->id]) }}#tab-3">See others</a></li>
                                @endif
                            @endif
                        </ul>
                        @if($case->service_user->person)
                            <h4>Demographics</h4>
                            <ul style="padding-left:15px;">
                                <li>Gender: <strong>{!! $case->service_user->person->gender ? $case->service_user->person->gender->name : "<span class='text-muted'>Not specified</span>" !!}</strong></li>
                                <li>Age: <strong>{!! $case->service_user->person->age ? $case->service_user->person->age : "<span class='text-muted'>Not specified</span>" !!}</strong></li>
                                @if(Auth::user()->can('see:identifying-information'))
                                    <li>Location: <strong>{!! $case->service_user->person->contact && $case->service_user->person->contact->address ? $case->service_user->person->contact->address->town . ', ' . $case->service_user->person->contact->address->region : "<span class='text-muted'>Not specified</span>" !!}</strong></li>
                                @endif
                            </ul>
                        @endif
                    </div>
                    <div class="col-sm-6">
                        <h4>Case info</h4>
                        <ul style="padding-left:20px;">
                            <li>Cancer types: <strong>{!! $case->cancer_types->count() ? implode(', ',array_pluck($case->cancer_types->toArray(),'name')) : "<span class='text-muted'>Not specified</span>" !!}</strong></li>
                            <li>Case type: <strong>{!! $case->case_type !!}</strong></li>
                            <li>
                                Advocacy issues:
                                @if($case->advocacy_issues->count() == 0)
                                    <strong><span class="text-muted">Not specified</span></strong>
                                @else
                                    <ul>
                                        @foreach($case->advocacy_issues as $advocacy_issue)
                                            <li>{{ $advocacy_issue->name }}</li>
                                        @endforeach
                                    </ul>
                                @endif
                            </li>
                            <li>
                                Journey stage: <strong>{!! $case->journey_stage ? $case->journey_stage->name : "<span class='text-muted'>Not specified</span>" !!}</strong>
                            </li>
                        </ul>
                        <h4>Support Hours</h4>
                        <ul style="padding-left:20px;">
                            <li>Total activities: <strong>{{ $case->activities->count() }}</strong></li>
                            <li>Total support hours: <strong>{{ round(array_sum(array_pluck($case->activities->toArray(),'duration'))/60,1) }}</strong></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    Case History
                    @if($case->active_periods()->active()->count())
                        <span class="text-success" style="float:right;">
                            <i class="fa fa-fw fa-folder-open-o"></i>
                            Currently Open
                        </span>
                    @else
                        <span class="text-warning" style="float:right;">
                            <i class="fa fa-fw fa-folder-o"></i>
                            Currently Closed
                        </span>
                    @endif
                </h3>
            </div>
            @include(Sculpt::getView('partials.forms.active-periods-table'),['record' => $case])
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    Activities
                </h3>
            </div>
            @if($case->activities->count() == 0)
                <div class="panel-body">
                    <p class="text-muted">Not specified</p>
                </div>
            @else
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th style="width:120px;">Date</th>
                            <th>Nature</th>
                            <th style="width:120px;">Undertaken by</th>
                            <th>Outcome</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($case->activities as $activity)
                            <tr>
                                <td>{!! $activity->date->format('jS M Y') !!}</td>
                                <td>{!! $activity->nature ? $activity->nature->name : "<span class='text-muted'>Not specified</span>" !!}</td>
                                @if(isset($activity->user->employee->person->name))
                                    <td>{!! $activity->user->employee->person->name !!}</td>
                                @else
                                    <td class="text-muted">Not specified</td>
                                @endif
                                <td>
                                    @if(Auth::user()->can('see:identifying-information'))
                                        {!! $activity->outcome ?: "<span class='text-muted'>Not specified</span>" !!}
                                    @else
                                        <span class="text-muted">Not available with observer role</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    Outcomes
                </h3>
            </div>
            @if($case->advocacy_outcomes->count() == 0)
                <div class="panel-body">
                    <p class="text-muted">Not specified</p>
                </div>
            @else
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Outcome</th>
                            <th>No</th>
                            <th>Partially</th>
                            <th>Yes</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($case->advocacy_outcomes as $outcome)
                            <tr>
                                <td>{{ $outcome->name }}</td>
                                <td>{!! $outcome->pivot->level == 1 ? "<i class='fa fa-check'></i>" : "" !!}</td>
                                <td>{!! $outcome->pivot->level == 2 ? "<i class='fa fa-check'></i>" : "" !!}</td>
                                <td>{!! $outcome->pivot->level == 3 ? "<i class='fa fa-check'></i>" : "" !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>

    @endif

@stop

@section('sidebar-buttons')
    <button class="btn btn-primary btn-block" onclick="window.print();"><i class="fa fa-fw fa-print"></i> Print</button>
    @if(Auth::user()->can(['see:service-user-cases']))
        <a href="{{ route('sculpt.show',['service-user-cases',$case->id]) }}" class="btn btn-default btn-block"><i class="fa fa-fw fa-angle-left"></i> Back to case</a>
    @endif
@stop