@extends('sculpt::auto.index')

@section('title')
    <h1>
        {!! Config::get('sculpt.icon-' . $model->getSlugged()) !!}
        {{ Sculpt::getTrans('index-title',$model->getHumanReadablePlural()) }}
    </h1>
    <p>Service users are individuals supported by the programme.</p>
@stop

@section('filter-form')
    <div class="panel panel-default">
        {!! Form::open(['method' => 'get','class' => 'form-horizontal does-not-cause-unsaved-changes']) !!}
        <div class="panel-body" style="padding-bottom:0;">
            <div class="row">
                @if(Auth::user()->can('see:identifying-information'))
                    <div class="col-sm-5">
                        <div class="for-group form-group-sm">
                            {!! Form::label('name','Name',['class' => 'col-sm-2 control-label']) !!}
                            <div class="col-sm-10">
                                {!! Form::text('name',isset($filters['name']) ? $filters['name'] : null,['class' => 'form-control']) !!}
                            </div>
                        </div>
                    </div>
                @endif
                <div class="col-sm-3">
                    <div class="form-group form-group-sm">
                        {!! Form::label('case_id','Case ID',['class' => 'col-sm-5 control-label']) !!}
                        <div class="col-sm-7">
                            {!! Form::text('case_id',isset($filters['case_id']) ? $filters['case_id'] : null,['class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="panel-footer">
            <button type="submit" class="btn btn-primary search-button">
                <i class="fa fa-fw fa-search"></i> Filter
            </button>
            @if(!empty($filters))
                <button name="clear" value="clear" type="submit" class="btn btn-default search-button" style="float:right;">
                    <i class="fa fa-fw fa-times"></i> Reset filter
                </button>
            @endif
        </div>
        {!! Form::close() !!}
    </div>
@stop

@section('table')
    <table class='table table-striped table-hover'>
        @section('table-head')
            <thead>
            <th>Name</th>
            <th width="110">Case count</th>
            <th>Cases</th>
            </thead>
        @show
        @foreach($records as $record)
            <tr data-href="{{ route('sculpt.show',['service-users',$record->id])  }}">
                @if($record->isActive())
                    <td>
                        {!! $record->name !!}
                    </td>
                    <td>
                        {!! $record->cases()->count() !!}
                    </td>
                    <td>
                        @foreach ($record->cases as $case)
                            {!! ($case->isActive()) ? '<span class="text-success"><i class="fa fa-fw fa-folder-open-o"></i>' : '<span class="text-warning"><i class="fa fa-fw fa-folder-o"></i>' !!} #{{ $case->id }}</span>
                        @endforeach
                    </td>
                @else
                    <td class="text-muted">
                        {!! $record->name !!}
                    </td>
                    <td>
                        {!! $record->cases()->count() !!}
                    </td>
                    <td>
                        @foreach ($record->cases as $case)
                            {!! ($case->isActive()) ? '<span class="text-success"><i class="fa fa-fw fa-folder-open-o"></i>' : '<span class="text-muted"><i class="fa fa-fw fa-folder-o"></i>' !!} #{{ $case->id }}</span>
                        @endforeach
                    </td>
                @endif
            </tr>
        @endforeach
    </table>
@stop