@extends('sculpt::auto.show')

@section('title')
    <h1>
        <span>
            {{ Sculpt::getTrans('show-title') }}:
        </span>
        {{ $record->name }}
    </h1>
    @if($record->isActive())
        <p class="text-success">
            <i class="fa fa-fw fa-folder-open-o"></i>
            <?= $record->person->preferred_name ? $record->person->preferred_name : $record->person->first_name ?> currently has an open case.
            <a href="#" data-trigger="#tab-link-cases">See cases <i class="fa fa-angle-right"></i></a>
        </p>
    @else
        @if (Auth::user()->can('see:identifying-information'))
            <p class="text-warning">
                <i class="fa fa-fw fa-folder-o"></i>
                <?= $record->person->preferred_name ? $record->person->preferred_name : $record->person->first_name ?> currently does not have an open case.
                <a href="#" data-trigger="#tab-link-cases">See cases</a> or
                <a href="{{ route('sculpt.create',['service-user-cases']) }}" >open new case <i class="fa fa-angle-right"></i></a>
            </p>
        @endif
    @endif
@stop