<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Personnel\Models\Nature;
use Concore\Personnel\Models\Timeslot;
use Input, Session, Config, DB, Carbon\Carbon;
use Illuminate\Contracts\View\View;

class ActivityFilterFormComposer {

    /**
     * @var Nature
     */
    private $nature;
    /**
     * @var Timeslot
     */
    private $timeslot;

    public function __construct(Nature $nature, Timeslot $timeslot) {
        $this->nature = $nature;
        $this->timeslot = $timeslot;
    }

    public function compose(View $view) {
        $natures_list = [''=>''];
        foreach($this->nature->lists('name','id') as $id => $name) {
            $natures_list[$id] = $name;
        }
        $natures_list['undefined'] = 'Undefined';
        $natures_list['other'] = 'Other';
        $timeslot_types_list = [''=>''];
        foreach($this->timeslot->getTimeslotTypes() as $index => $type) {
            $timeslot_types_list[$index] = $type;
        }
        $dates_list = ['' => ''];
        $date = Carbon::createFromFormat('Y-m','2012-01');
        while($date <= Carbon::now()) {
            $dates_list[$date->format('Y-m')] = $date->format('F Y');
            $date->addMonth();
        }
        $view->with(compact('natures_list','timeslot_types_list','dates_list'));
    }

}