<?php namespace Concore\Sam\Http\ViewComposers;

use Config;
use Concore\Personnel\Models\Gender;
use Concore\Sam\Models\Person;
use Concore\Sculpt\Models\Role;
use Illuminate\Contracts\View\View;

class EmployeeFilterFormComposer extends PersonFilterFormComposer {

    /**
     * @var Role
     */
    private $role;

    public function __construct(Gender $gender, Person $person, Role $role) {
        $this->role = $role;
        parent::__construct($gender, $person);
    }

    public function compose(View $view) {
        parent::compose($view);
        $roles = [];
        foreach(Role::whereIn('name',Config::get('sculpt.allowed-roles.employees'))->lists('display_name','id') as $id => $role) {
            $roles[$id] = $role;
        }
        $view->with('roles',$roles);
    }

}