<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Personnel\Models\Gender;
use Concore\Sam\Models\AdvocacyIssue;
use Concore\Sam\Models\AdvocacyOutcome;
use Concore\Sam\Models\CancerType;
use Concore\Sam\Models\JourneyStage;
use Concore\Sam\Models\Person;
use Concore\Sam\Models\ReferralMethod;
use Concore\Sam\Models\ReferralSource;
use Carbon\Carbon;
use Concore\Sam\Models\ServiceUserCase;
use Concore\Sam\Models\Sexuality;
use Illuminate\Contracts\View\View;

class ServiceUserCaseFilterFormComposer extends PersonFilterFormComposer {

    /**
     * @var Gender
     */
    private $gender;
    /**
     * @var ReferralMethod
     */
    private $referral_method;
    /**
     * @var ReferralSource
     */
    private $referral_source;
    /**
     * @var Person
     */
    private $person;
    /**
     * @var ServiceUserCase
     */
    private $service_user_case;
    /**
     * @var JourneyStage
     */
    private $journey_stage;

    public function __construct(
        Gender $gender,
        Person $person,
        Sexuality $sexuality,
        ReferralMethod $referral_method,
        ReferralSource $referral_source,
        ServiceUserCase $service_user_case,
        JourneyStage $journey_stage,
        CancerType $cancer_type,
        AdvocacyIssue $advocacy_issue,
        AdvocacyOutcome $advocacy_outcome
    ) {
        $this->sexuality = $sexuality;
        $this->referral_method = $referral_method;
        $this->referral_source = $referral_source;
        $this->service_user_case = $service_user_case;
        $this->journey_stage = $journey_stage;
        $this->cancer_type = $cancer_type;
        $this->advocacy_issue = $advocacy_issue;
        $this->advocacy_outcome = $advocacy_outcome;
        parent::__construct($gender, $person);
    }

    public function compose(View $view) {
        parent::compose($view);
        $sexualities = ['' => ''];
        foreach($this->sexuality->lists('name','id') as $id => $name) {
            $sexualities[$id] = $name;
        }
        $sexualities['undefined'] = 'Undefined';
        $referral_methods = ['' => ''];
        foreach($this->referral_method->lists('name','id') as $id => $name) {
            $referral_methods[$id] = $name;
        }
        $referral_methods['undefined'] = 'Undefined';
        $referral_methods['other'] = 'Other';

        $referral_sources = ['' => ''];
        foreach($this->referral_source->lists('name','id') as $id => $name) {
            $referral_sources[$id] = $name;
        }
        $referral_sources['undefined'] = 'Undefined';
        $referral_sources['other'] = 'Other';

        $how_they_heards = ['' => ''];
        foreach($this->service_user_case->getHowTheyHeards() as $name) {
            $how_they_heards[$name] = $name;
        }
        $how_they_heards['Other'] = 'Other';
        $how_they_heards['Undefined'] = 'Undefined';

        $journey_stages = ['' => ''];
        foreach($this->journey_stage->lists('name','id') as $id => $name) {
            $journey_stages[$id] = $name;
        }
        $journey_stages['Undefined'] = 'Undefined';
        $journey_stages['Other'] = 'Other';

        $cancer_types = ['' => ''];
        foreach($this->cancer_type->lists('name','id') as $id => $name) {
            $cancer_types[$id] = $name;
        }
        $cancer_types['Undefined'] = 'Undefined';
        $cancer_types['Other'] = 'Other';

        $advocacy_issues = ['' => ''];
        foreach($this->advocacy_issue->lists('name','id') as $id => $name) {
            $advocacy_issues[$id] = $name;
        }
        $advocacy_issues['Undefined'] = 'Undefined';
        $advocacy_issues['Other'] = 'Other';

        $advocacy_outcomes = ['' => ''];
        foreach($this->advocacy_outcome->lists('name','id') as $id => $name) {
            $advocacy_outcomes[$id] = $name;
        }
        $advocacy_outcomes['Undefined'] = 'Undefined';
        $advocacy_outcomes['Other'] = 'Other';

        $view->with(compact('sexualities','referral_methods','referral_sources','how_they_heards','journey_stages','cancer_types','advocacy_issues','advocacy_outcomes'));
    }

}