<?php namespace Concore\Sam\Models;

use DB;

class Timeslot extends \Concore\Personnel\Models\Timeslot {

    public $fields_with_other = ['type'];

    public $validation_rules = [
        'timeslot.type' => 'required_without:{timeslot}.type_other',
        'timeslot.duration' => 'required_with:{timeslot}.type,{timeslot}.type_other'
    ];

    public function getTimeslotTypes() {
        $type = DB::select( DB::raw("SHOW COLUMNS FROM timeslots WHERE Field = 'type'") )[0]->Type;
        preg_match('/^enum\((.*)\)$/', $type, $matches);
        return array_map(function($value) {
            return trim($value,"'");
        },explode("','", $matches[1]));
    }

}