<?php namespace Concore\Sam\Services\Sculpt;

use App\Models\Task;
use Auth, Session, Carbon\Carbon;
use Concore\Personnel\Services\Sculpt\TaskService as ParentClass;
use Concore\Sam\Models\Timeslot;
use Concore\Sculpt\Services\Interfaces\AutoServiceInterface;

class TaskService extends ParentClass {

    /**
     * @var Timeslot
     */
    private $timeslot;

    public function __construct(AutoServiceInterface $auto_service, Task $task, Timeslot $timeslot) {
        parent::__construct($auto_service);
        $this->timeslot = $timeslot;
    }

    public function queryIndex() {
        $query = parent::queryIndex();
        if(Auth::user()->hasRole('advocate') && !Auth::user()->can('see:all-activities')) {
            $query = $query->whereHas('service_user_case',function($query) {
                $query->forAdvocate(Auth::user()->employee->advocate->id);
            });
        }
        if($input = Session::get('forms.search.activities')) {
            if(Auth::user()->can('see:all-organisations')) {
                if($this->inputHas($input,'organisation_id')) {
                    $query->whereHas('service_user_case',function($query) use($input) {
                        $query->whereHas('service_user',function($query) use($input) {
                            $query->whereHas('person',function($query) use($input) {
                                $query->where('organisation_id', '=', $input['organisation_id']);
                            });
                        });
                    });
                }
            }
            if($this->inputHas($input,'date_from')) {
                $query->where('date','>=',Carbon::createFromFormat('Y-m-d G:i:s',$input['date_from'] . '-01 00:00:00')->format('Y-m-d H:i:s'));
            }
            if($this->inputHas($input,'date_to')) {
                $query->where('date','<=',Carbon::createFromFormat('Y-m-d G:i:s',$input['date_to'] . '-01 23:59:59')->format('Y-m-t H:i:s'));
            }
            if($this->inputHas($input,'nature')) {
                if($input['nature'] === 'other') {
                    $query->whereNotNull('nature_other');
                } else if($input['nature'] === 'undefined') {
                    $query->where(function($query) {
                        $query->whereNull('nature_id')->whereNull('nature_other');
                    });
                } else {
                    $query->where('nature_id','=',$input['nature']);
                }
            }
            if($this->inputHas($input,'timeslot_type')) {
                $timeslot_types = $this->timeslot->getTimeslotTypes();
                $query->whereHas('timeslots',function($query) use($timeslot_types, $input) {
                    $query->where('type','=',$timeslot_types[intval($input['timeslot_type'])]);
                });
            }
        }
        return $query;
    }

    protected function saveRecord($record, $input) {

        if (isset($input['task']['service_user_case_id']) && isset($input['next-activity'])) {
            $input['next-activity'][0]['task']['service_user_case_id'] = $input['task']['service_user_case_id'];
        }

        if(!empty($input['activity']['user_id'])) {
            $input['user'] = [
                'id' => $input['activity']['user_id'],
                'last_activity_date' => $input['activity']['date']
            ];
        }
        if(!empty($input['activity']['service_user_case_id'])) {
            $input['service-user-case'] = [
                'id' => $input['activity']['service_user_case_id'],
                'last_activity_date' => $input['activity']['date']
            ];
        }

        return parent::saveRecord($record,$input);
    }

}