<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdvocacyIssueServiceUserCaseTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('advocacy_issue_service_user_case',function(Blueprint $table) {
            $table->integer('advocacy_issue_id')->unsigned();
            $table->foreign('advocacy_issue_id')->references('id')->on('advocacy_issues')->onDelete('cascade');
            $table->integer('service_user_case_id')->unsigned();
            $table->foreign('service_user_case_id')->references('id')->on('service_user_cases')->onDelete('cascade');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::dropTable('advocacy_issue_service_user_case');
	}

}
