<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAccommodationTypesReferralSourcesToServiceUserCasesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
            $table->dropColumn('accommodation_type');
            $table->dropColumn('how_heard');
            $table->dropColumn('how_heard_other');
            $table->integer('accommodation_type_id')->unsigned()->nullable()->after('no_advocate_needed');
            $table->foreign('accommodation_type_id')->references('id')->on('accommodation_types')->onDelete('cascade');
            $table->integer('referral_source_id')->unsigned()->nullable()->after('accommodation_type_other');
            $table->foreign('referral_source_id')->references('id')->on('referral_sources')->onDelete('cascade');
            $table->string('referral_source_other')->nullable()->after('referral_source_id');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::table('service_user_cases', function(Blueprint $table)
        {
            $table->dropColumn('referral_source_other');
            $table->string('how_heard_other')->nullable()->after('accommodation_type_other');
            $table->dropForeign('service_user_cases_accommodation_type_id_foreign');
            $table->dropColumn('accommodation_type_id');
            $table->dropForeign('service_user_cases_referral_source_id_foreign');
            $table->dropColumn('referral_source_id');
            $table->enum('accommodation_type',['Hospital','Own home alone','Own home with others','Nursing home','Staying with relatives or friends','Residential home','Sheltered accommodation','Other'])->nullable()->after('service_user_id');
            $table->enum('how_heard',['From the internet','Macmillan publication','Macmillan representative','National press','Local press','Posters\, flyers or leaflets','Cancer champion talks to local groups','Word of mouth','Other'])->nullable()->after('service_user_id');
        });
	}

}
