<?php return [
    'dashboard' => [
        'welcome' => 'Welcome'
    ],
    'account' => [
        'title' => 'My Account'
    ],
    'auth' => [
        'password-reset-sent' => 'A link to reset your password has been sent to you by email.'
    ],
    'auto' => [
        'index-title' => 'All %s',
        'show-title' => 'Showing %s',
        'create-title' => 'New %s',
        'create-new' => 'Add new %s',
        'reorder' => 'Reorder %s',
        'reorder-success' => '%s reordered successfully.',
        'reorder-error' => 'The %s could not be reordered.',
        'delete-this' => 'Delete this %s',
        'create-this' => 'Add %s',
        'update-this' => 'Update %s',
        'debug-input' => 'Debug input',
        'show-view-hints' => 'Show view hints',
        'hide-view-hints' => 'Hide view hints',
        'created-successfully' => 'New %s added successfully.',
        'created-error' => 'The %s could not be added.',
        'updated-successfully' => 'The %s was updated successfully.',
        'updated-error' => 'The %s could not be updated.',
        'deleted-successfully' => 'The %s was deleted.',
        'deleted-error' => 'The %s could not be deleted.',
        'navigation-title' => '%s',
        'navigation-all' => 'All %s',
        'navigation-new' => 'New %s',
        'show-this' => 'Show on front-end',
        'remove-this' => 'Remove',
        'back-to-index-from-create' => 'Back',
        'back-to-index-from-show' => 'Back',
        'name-column' => 'Name',
        'updated-column' => 'Last updated',
        'validation-errors' => 'The information you provided could not be saved. Please check over the messages below and amend appropriately.',
        'field-labels' => [
            'activities_duration' => 'Total activity duration',
            'activities_average_duration' => 'Average activity duration',
            'activities_number' => 'Number of activities'
        ], // default field labels
        'fields-hints' => [],
        'has-many-new-relation' => 'New %s'
    ],
    'people' => [
        'field-labels' => [
            'location_id' => 'Office'
        ]
    ],
    'contacts' => [
        'field-labels' => [
            'phone1' => 'Phone 1',
            'phone2' => 'Phone 2',
            'gplus' => 'Google+',
            'linkedin' => 'LinkedIn'
        ]
    ],
    'media' => [
        'show-this' => 'View media'
    ],
    'activities' => [
        'index-title' => 'All activities',
        'show-title' => 'Showing activities',
        'create-title' => 'New activity',
        'create-new' => 'Add new activity',
        'reorder' => 'Reorder activities',
        'reorder-success' => 'Activity reordered successfully.',
        'reorder-error' => 'The activities could not be reordered.',
        'delete-this' => 'Delete this activity',
        'create-this' => 'Add activity',
        'update-this' => 'Update activity',
        'created-successfully' => 'New activity added successfully.',
        'created-error' => 'The activity could not be added.',
        'updated-successfully' => 'The activity was updated successfully.',
        'updated-error' => 'The activity could not be updated.',
        'deleted-successfully' => 'The activity was deleted.',
        'deleted-error' => 'The activity could not be deleted.',
        'navigation-title' => 'Activities',
        'navigation-all' => 'All Activities',
        'navigation-new' => 'New Activity',
        'has-many-new-relation' => 'New Activity',
        'field-labels' => [
            'date' => 'Date of activity',
            'nature_id' => 'Nature of activity',
            'review_previous' => 'Review of activity prior to this one',
            'outcome' => 'Outcome of this activity',
            'planned_action' => 'Previously planned action for this activity',
            'user_id' => 'Undertaken by'
        ],
        'field-hints' => [
            'people_present' => 'Include anybody that was present here, including the advocate and service user.',
            'service_user_case_id' => 'If this activity was not related to a particular case (e.g. training, internal meetings) leave this blank.'
        ],
        'next-activity' => [
            'edit-button' => 'Go to activity',
            'add-button' => 'Add next activity',
            'cancel-button' => 'Cancel',
            'cancel_unwanted_notice' => 'Please cancel this activity if you no longer need it.',
            'field-labels' => [
                'planned_action' => 'Planned action'
            ]
        ]
    ],
    'contact-entities' => [
        'index-title' => 'All contacts',
        'show-title' => 'Showing contacts',
        'create-title' => 'New contact',
        'create-new' => 'Add new contact',
        'reorder' => 'Reorder contacts',
        'reorder-success' => 'Contacts reordered successfully.',
        'reorder-error' => 'The contacts could not be reordered.',
        'delete-this' => 'Delete this contact',
        'create-this' => 'Add contact',
        'update-this' => 'Update contact',
        'created-successfully' => 'New contact added successfully.',
        'created-error' => 'The contact could not be added.',
        'updated-successfully' => 'The contact was updated successfully.',
        'updated-error' => 'The contact could not be updated.',
        'deleted-successfully' => 'The contact was deleted.',
        'deleted-error' => 'The contact could not be deleted.',
        'navigation-title' => 'Contacts',
        'navigation-all' => 'All Contacts',
        'navigation-new' => 'New Contact',
        'has-many-new-relation' => 'New Contact',
        'field-labels' => [
            'company_id' => 'Belongs to company'
        ]
    ],
    'notes' => [
        'field-labels' => [
            'contact_entity_id' => 'Linked contact'
        ]
    ],
    'contacts' => [
        'field-labels' => [
            'email' => 'Contact Email',
            'phone1' => 'Phone 1',
            'phone2' => 'Phone 2'
        ]
    ],
    'users' => [
        'field-labels' => [
            'email' => 'Login Email'
        ]
    ],
    'service-user-cases' => [
        'index-title' => 'All cases',
        'show-title' => 'Showing cases',
        'create-title' => 'New case',
        'create-new' => 'Add new case',
        'reorder' => 'Reorder cases',
        'reorder-success' => 'Cases reordered successfully.',
        'reorder-error' => 'The cases could not be reordered.',
        'delete-this' => 'Delete this case',
        'create-this' => 'Add case',
        'update-this' => 'Update case',
        'created-successfully' => 'New case added successfully.',
        'created-error' => 'The case could not be added.',
        'updated-successfully' => 'The case was updated successfully.',
        'updated-error' => 'The case could not be updated.',
        'deleted-successfully' => 'The case was deleted.',
        'deleted-error' => 'The case could not be deleted.',
        'navigation-title' => 'Cases',
        'navigation-all' => 'All Cases',
        'navigation-new' => 'New Case',
        'has-many-new-relation' => 'New Case',
        'field-labels' => [
            'how_they_heard' => 'How they heard about the project?'
        ],
        'field-hints' => [
            'case_type' => '<p>If the service user has cancer themselves, choose <strong>Patient</strong>.</p><p>If the service user cares for someone with cancer, choose <strong>Carer</strong> and fill the rest of the form using details for the person receiving care.</p>'
        ]
    ],
    'reminders' => [
        'index-title' => 'All %s',
        'show-title' => 'Showing %s',
        'create-title' => 'New %s',
        'create-new' => 'Add new %s',
        'reorder' => 'Reorder %s',
        'reorder-success' => '%s reordered successfully.',
        'reorder-error' => 'The %s could not be reordered.',
        'delete-this' => 'Delete this %s',
        'create-this' => 'Add %s',
        'update-this' => 'Update %s',
        'created-successfully' => 'New %s added successfully.',
        'created-error' => 'The %s could not be added.',
        'updated-successfully' => 'The %s was updated successfully.',
        'updated-error' => 'The %s could not be updated.',
        'deleted-successfully' => 'The %s was deleted.',
        'deleted-error' => 'The %s could not be deleted.',
        'navigation-title' => '%s',
        'navigation-all' => 'All %s',
        'navigation-new' => 'New %s',
        'show-this' => 'Show on front-end',
        'back-to-index-from-create' => 'Back',
        'back-to-index-from-show' => 'Back',
        'name-column' => 'Name',
        'updated-column' => 'Last updated',
        'validation-errors' => 'The information you provided could not be saved. Please check over the messages below and amend appropriately.',
        'field-labels' => ['remindee_user_id' => 'User to remind','title' => 'Reminder','notes' => 'More info']
    ],
    'employees' => [
        'index-title' => 'Local Team',
        'show-title' => 'Showing local team',
        'create-title' => 'New local team member',
        'create-new' => 'Add new local team member',
        'reorder' => 'Reorder local team members',
        'reorder-success' => 'Local team members reordered successfully.',
        'reorder-error' => 'The local team members could not be reordered.',
        'delete-this' => 'Delete this local team member',
        'create-this' => 'Add local team member',
        'update-this' => 'Update local team member',
        'created-successfully' => 'New local team member added successfully.',
        'created-error' => 'The local team member could not be added.',
        'updated-successfully' => 'The local team member was updated successfully.',
        'updated-error' => 'The local team member could not be updated.',
        'deleted-successfully' => 'The local team member was deleted.',
        'deleted-error' => 'The local team member could not be deleted.',
        'navigation-title' => 'Local Team',
        'navigation-all' => 'Local Team',
        'navigation-new' => 'New Local Team Member',
        'has-many-new-relation' => 'New local team member'
    ]
];