@extends('personnel::vendor.sculpt.active-periods.end')

@section('intro')
    @if($active_period->role_id === 8)
        <h1>Close Case</h1>
        {!! Notification::showAll() !!}
        @include('sculpt::validation-errors')
        <p>Please provide a reason for closing this case.</p>
    @else
        @parent
    @endif
@stop

@section('submit')
    @if($active_period->role_id === 8)
        <p class="alert alert-warning">
            <i class="fa fa-fw fa-exclamation-circle"></i> After closing a case, please make sure you complete <strong>activity outcomes</strong> for this case.
        </p>
    @endif
    {!! Form::submit($active_period->role_id === 8 ? 'Close case' : 'Deactivate',['class' => 'btn btn-primary update-button']) !!}
@stop