<h1>Contacts</h1>

<p>An unlimited amount of contacts can be added to cases, service users and employees.</p>

<div class="panel panel-default screen-only">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-fw fa-list"></i> Contents</h3>
    </div>
    <ul class="list-group">
        <li class="list-group-item"><a href="#_add">Add a new contact</a></li>
        <li class="list-group-item"><a href="#_remove">Remove or unlink a contact</a></li>
    </ul>
</div>

<section id="_add">

    <h2>Add a New Contact</h2>

    <p>Imagine we're adding a new contact to <em>Adam Brown</em>'s case.</p>

    <p class="alert alert-info">
        For more information on when to add contacts to a case and when to add to a service user, see {!! link_to("$docs/faq#_notes_su_case","Should I enter a note/contact on a case or service user?") !!}
    </p>

    <div class="no-break">
        <h4>Step 1</h4>
        <p>First, {!! link_to("$docs/finding-information#_team_member","find Adam's case") !!}.</p>
    </div>

    <div class="no-break">
        <h4>Step 2</h4>
        <p>
            Click on the <strong>Contacts</strong> tab. If Adam has any contacts already, they will be shown here in a table summarising their email, phone number(s) and contact type (e.g. next of kin, referrer, etc).
        </p>
    </div>

    <p>To add a new contact, click <strong><i class="fa fa-phone"></i> Add contact</strong>. From here we will be prompted for the following information:</p>

    <div class="no-break">
        <h5>Type</h5>
        <p>A contact type, e.g. next of kin, referrer, previous employer, etc.</p>
    </div>

    <div class="no-break">
        <h5>Choose existing or create new</h5>
        <p>It is worth checking here whether the contact we're about to add has already been added to the system for another case (remember we can click on a dropdown and start typing on the keyboard to filter results). This is often the case with GPs or previous employers, for example.</p>
    </div>

    <p>If we click <strong><i class="fa fa-plus"></i> Create new</strong> you will be prompted for the contact name and information.</p>

    <p class="alert alert-info">We will be able to choose whether this contact is a company rather than a specific person, or if the contact belongs to a company already entered.</p>

    <p class="alert alert-warning">
        <strong>Important:</strong> Once a contact has been added to the system, they exist independently of the case or team member they were added to. This means that other cases can be linked to the same contact. This is useful when, for example, several cases are linked to a particular GP or several team members have the same previous employer.
    </p>

    <div class="no-break">
        <h5>Notes</h5>
        <p>We can also add notes to individual contacts for any other information. These notes are specific to the case or team member, and are not shared by other people that are linked to the same contact.</p>
    </div>

    <div class="no-break">
        <h4>Step 3</h4>
        <p>Click <strong><i class="fa fa-check"></i> Done</strong> and then <strong><i class="fa fa-floppy-o"></i> Update case</strong> in order to case the contact.</p>
    </div>

</section>

<section id="_remove">

    <h2>Remove a contact</h2>

    <p>There are actually two ways to remove a contact, the first is to <strong>unlink</strong> it from a case of team member, and the other is to remove it from the system altogether.</p>

    <p>When unlinking a contact, the contact is still available in the {!! link_to("$this/contacts/directory",'contacts directory') !!} and can be used by other records. Removing the contact altogether means it will be lost from all records to which it is associated.</p>

    <h4>Unlink a contact</h4>

    <p>When on the <strong>Contacts</strong> tab, simply click <strong><i class="fa fa-unlink"></i> Unlink</strong>. This means the contact will no longer show up on this case of team member, but will still be available in the contacts directory.</p>

    <h4>Remove a contact</h4>

    <p>Click on <strong>Contacts</strong> in the main navigation, then find the contact either by browsing through the pages or {!! link_to("$docs/finding-information#_filtering",'filtering') !!}. Once on the contact page, click on <strong><i class="fa fa-trash-o"></i> Delete this contact</strong>. This will remove the contact entirely from the system, and it will be lost from any cases or team members to which it is associated.</p>

    <p class="alert alert-info">
        If a contact is linked to more than one case or team member, SAM will notify us of this with a message at the top of the contact page.
    </p>

</section>