<h1>Reports</h1>

<div class="panel panel-default screen-only">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-fw fa-list"></i> Contents</h3>
    </div>
    <ul class="list-group">
        <li class="list-group-item"><a href="#_overview">Overview</a></li>
        <li class="list-group-item"><a href="#_activities">Activities</a></li>
        <li class="list-group-item"><a href="#_cases">Service User Cases</a></li>
        <li class="list-group-item"><a href="#_advocates">Advocates</a></li>
        <li class="list-group-item"><a href="#_cancer_champions">Cancer Champions</a></li>
    </ul>
</div>

<section id="_overview">

    <h2>Overview</h2>

    <p>Reports allow us to pull out key facts and figures on the data in SAM.</p>

    <p>To access reports, click <strong>Reports</strong> in the main navigation. From here we will see a report of the last month's data. We can tweak which dates are shown using the filter form at the top of the page.</p>

    <p>Reports are split into three tabs, outlined below.</p>

    <p class="alert alert-warning">
        <strong>Note:</strong> Only administrators can view reports on a national level. Coordinators and local administrators can view reports with local data. Advocates cannot view reports.
    </p>

    <h3>Click-through</h3>

    <p>With many figures, it is possible to click on a row in a table in order to be taken to the relevant records. For example, when looking at a table of gender demographics, we can click on the row that says <em>Female | 56</em> in order to see those 56 female records.</p>

    <h3>Export to Spreadsheet</h3>

    <p>Reports can be exported to an Excel Spreadsheet by clicking the <strong><i class="fa fa-table"></i> Export to Excel</strong> button in the top-right of each report.</p>


</section>


<section id="_activities">

    <h2>Activities</h2>

    <p>Under Activites we're able to see key figures at the top:</p>

    <ul>
        <li>The total number of activities logged in the date range.</li>
        <li>The total duration of all activities in the date range combined.</li>
        <li>The average duration of an activity in the date range.</li>
    </ul>

    <p>We're also able to see these figures broken down by activity nature and what each activity involved below. In addition to this, we're able to see how many cases these spanned.</p>

    <p class="alert alert-info">
        <strong>Example:</strong> If a row in the report reads 'Independently researching information, Quantity: 80, Total Duration: 40 hr, Average duration: 30 min, Service Users: 34' this means there were 80 activities with this nature that lasted 40 hours in total with a 30 min average duration. The activities were spread over 34 different service user cases.
    </p>

</section>

<section id="_cases">

    <h2>Service User Cases</h2>

    <p>For cases, we can see the following key figures:</p>

    <ul>
        <li>Open and closed cases at the start of the period.</li>
        <li>New cases opened and existing cases reopened during the period.</li>
        <li>Cases closed during the period.</li>
        <li>
            <p>Open cases at the end of the period.</p>
            <p class="alert alert-info">
                This can be calculated by the number of open cases at the start, plus cases opened and reopened, minus cases closed.
            </p>
        </li>
        <li>
            <p>Closed cases at the end of the period.</p>
            <p class="alert alert-info">
                This can be calculated by the number of closed cases at the start, plus cases closed, minus existing cases reopened.
            </p>
        </li>
        <li>Average number of activities received by a case during this period, and the average total hours' support received on a case during this period.</li>
    </ul>

    <p>We can also see demographic information for all cases opened during the period, including gender, ethnicity and age.</p>

</section>

<section id="_advocates">

    <h2>Advocates (Volunteer and Paid)</h2>

    <p>Advocates are split into Volunteer and Paid advocates. For advocates, we can see the following key figures:</p>

    <ul>
        <li>Active and inactive advocates at the start of the period.</li>
        <li>New advocates activated and existing advocates reactivated during the period.</li>
        <li>Advocates deactivated during the period.</li>
        <li>
            <p>Active advocates at the end of the period.</p>
            <p class="alert alert-info">
                This can be calculated by the number of active advocates at the start, plus advocates activated and reactivated, minus advocates deactivated.
            </p>
        </li>
        <li>
            <p>Inactive advocates at the end of the period.</p>
            <p class="alert alert-info">
                This can be calculated by the number of inactive advocates at the start, plus advocates deactivated, minus existing advocates reactivated.
            </p>
        </li>
    </ul>

    <p>We can also see demographic information for all advocates activated during the period, including gender, ethnicity and age.</p>

</section>

<section id="_cancer_champions">

    <h2>Cancer Champions</h2>

    <p>For cancer champions, we can see the following key figures:</p>

    <ul>
        <li>Active and inactive cancer champions at the start of the period.</li>
        <li>New cancer champions activated and existing cancer champions reactivated during the period.</li>
        <li>Cancer champions deactivated during the period.</li>
        <li>
            <p>Active cancer champions at the end of the period.</p>
            <p class="alert alert-info">
                This can be calculated by the number of active cancer champions at the start, plus cancer champions activated and reactivated, minus cancer champions deactivated.
            </p>
        </li>
        <li>
            <p>Inactive cancer champions at the end of the period.</p>
            <p class="alert alert-info">
                This can be calculated by the number of inactive cancer champions at the start, plus cancer champions deactivated, minus existing cancer champions reactivated.
            </p>
        </li>
    </ul>

    <p>We can also see demographic information for all cancer champions activated during the period, including gender, ethnicity and age.</p>

</section>