<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Sam\Models\AdvocacyOutcome;
use Illuminate\Contracts\View\View;

class AdvocacyOutcomesComposer {

    /**
     * @var AdvocacyOutcome
     */
    private $advocacy_outcome;

    public function __construct(AdvocacyOutcome $advocacy_outcome) {
        $this->advocacy_outcome = $advocacy_outcome;
    }

    public function compose(View $view) {
        $view_data = $view->getData();
        $checked_outcomes = [];
        foreach($view_data['record']->advocacy_outcomes as $outcome) {
            $checked_outcomes[$outcome->id] = $outcome->pivot->level;
        }
        $advocacy_outcomes = $this->advocacy_outcome->orderBy('name','desc')->lists('name','id');
        $view->with(compact('advocacy_outcomes','checked_outcomes'));
    }

}