<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Personnel\Models\Gender;
use Concore\Sam\Models\Person;
use Carbon\Carbon;
use Illuminate\Contracts\View\View;

class PersonFilterFormComposer {

    /**
     * @var Gender
     */
    private $gender;
    /**
     * @var ReferralMethod
     */
    private $referral_method;
    /**
     * @var ReferralSource
     */
    private $referral_source;
    /**
     * @var Person
     */
    private $person;

    public function __construct(Gender $gender, Person $person) {
        $this->gender = $gender;
        $this->person = $person;
    }

    public function compose(View $view) {
        $genders = ['' => ''];
        foreach($this->gender->lists('name','id') as $id => $name) {
            $genders[$id] = $name;
        }
        $genders['undefined'] = 'Undefined';
        $ethnicities = ['' => ''];
        foreach($this->person->getEthnicities() as $name) {
            $ethnicities[$name] = $name;
        }
        $ethnicities['undefined'] = 'Undefined';
        $age_groups = ['' => ''];
        foreach(config('sam.reporting-age-groups') as $group) {
            $age_groups[$group] = $group;
        }
        $age_groups['undefined'] = 'Undefined';
        $dates_list = ['' => ''];
        $date = Carbon::createFromFormat('Y-m','2012-01');
        while($date <= Carbon::now()) {
            $dates_list[$date->format('Y-m')] = $date->format('F Y');
            $date->addMonth();
        }
        $view->with(compact('genders','ethnicities','age_groups','dates_list'));
    }

}