<?php namespace Concore\Sam\Models;

use DB, Carbon\Carbon;
use Concore\Personnel\Models\User as ParentUser;

class User extends ParentUser
{

    public $dates = ['created_at','updated_at','last_activity'];

    protected $fillable = ['name', 'email', 'password', 'last_activity_date'];

    public static function boot() {
        static::saving(function($record) {
            // Only update last_activity if it's later than the current one
            $current = $record->find($record->id);
            if($record->last_activity && $current->last_activity && $current->last_activity > $record->last_activity) {
                $record->last_activity = $current->last_activity;
            }
        });
    }

    public function daysSinceLastActivity() {
        return $this->last_activity ? $this->last_activity->diffInDays(Carbon::now()) : null;
    }

}