<?php namespace Concore\Sam\Providers;

use View;
use Illuminate\Support\ServiceProvider;

class SamServiceProvider extends ServiceProvider {

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register() {
		$this->middleware();
        $this->config();
        $this->override_views();
        $this->service_providers();
        $this->bindings();
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{
        // Load routes in boot() after other service providers' register() has run because it depends on config from sculpt
        $this->routes();

        $this->validation_rules();

		$this->composers();

		$this->loadViewsFrom(__DIR__.'/../../resources/views', 'sam');
    
        $this->loadTranslationsFrom(__DIR__.'/../../resources/lang/vendor/sculpt', 'sculpt');

		// Publishes 
		
		//$this->publishes([
	    //    __DIR__.'/../../public' => base_path('public/vendor/sculpt'),
	    //], 'assets');
		//$this->publishes([
	    //    __DIR__.'/../../resources/views' => base_path('resources/views/vendor/sculpt'),
	    //], 'views');
		//$this->publishes([
	    //    __DIR__.'/../../migrations' => base_path('database/migrations'),
	    //], 'migrations');

        $this->macros();
	}

    protected function override_views() {
        // Can override Sculpt package's views
        $this->app['view']->addNamespace('sculpt',__DIR__.'/../../resources/views/vendor/sculpt');
        $this->app['view']->addNamespace('auditing',__DIR__.'/../../resources/views/vendor/auditing');
        $this->app['view']->addNamespace('reports',__DIR__.'/../../resources/views/vendor/reports');
    }

	protected function bindings()
	{
        // People
        $this->app->bind('Concore\Personnel\Models\Person','Concore\Sam\Models\Person');
        $this->app->bind('Concore\Personnel\Models\Employee','Concore\Sam\Models\Employee');
        $this->app->bind('Concore\Personnel\Models\User','Concore\Sam\Models\User');
        // Service Users
        $this->app->bind('sculpt-model.service-user','Concore\Sam\Models\ServiceUser');
        $this->app->tag('sculpt-model.service-user','sculpt-models');
        $this->app->bind('sculpt-service.service-user-service','Concore\Sam\Services\Sculpt\ServiceUserService');
        $this->app->tag('sculpt-service.service-user-service','sculpt-services');
        $this->app->bind('sculpt-controller.service-user-controller','Concore\Sam\Http\Controllers\Sculpt\ServiceUserController');
        $this->app->bind('sculpt-service.service-user-case-service','Concore\Sam\Services\Sculpt\ServiceUserCaseService');
        $this->app->tag('sculpt-service.service-user-case-service','sculpt-services');
        // Cases
        $this->app->bind('sculpt-model.service-user-case','Concore\Sam\Models\ServiceUserCase');
        $this->app->tag('sculpt-model.service-user-case','sculpt-models');
        $this->app->bind('sculpt-model.cancer-type','Concore\Sam\Models\CancerType');
        $this->app->tag('sculpt-model.cancer-type','sculpt-models');
        $this->app->bind('sculpt-model.advocacy-issue','Concore\Sam\Models\AdvocacyIssue');
        $this->app->tag('sculpt-model.advocacy-issue','sculpt-models');
        $this->app->bind('sculpt-model.advocacy-outcome','Concore\Sam\Models\AdvocacyOutcome');
        $this->app->tag('sculpt-model.advocacy-outcome','sculpt-models');
        $this->app->bind('sculpt-service.service-user-case-service','Concore\Sam\Services\Sculpt\ServiceUserCaseService');
        $this->app->tag('sculpt-service.service-user-case-service','sculpt-services');
        $this->app->bind('sculpt-controller.service-user-case-controller','Concore\Sam\Http\Controllers\Sculpt\ServiceUserCaseController');
        // Employees
        $this->app->bind('sculpt-service.employee-service','Concore\Sam\Services\Sculpt\EmployeeService');
        $this->app->tag('sculpt-service.employee-service','sculpt-services');
        $this->app->bind('sculpt-controller.employee-controller','Concore\Sam\Http\Controllers\Sculpt\EmployeeController');
        // Advocates
        $this->app->bind('sculpt-model.advocate','Concore\Sam\Models\Advocate');
        $this->app->tag('sculpt-model.advocate','sculpt-models');
        $this->app->bind('sculpt-model.cancer-champion','Concore\Sam\Models\CancerChampion');
        $this->app->tag('sculpt-model.cancer-champion','sculpt-models');
        $this->app->bind('sculpt-model.advocate-motivation','Concore\Sam\Models\AdvocateMotivation');
        $this->app->tag('sculpt-model.advocate-motivation','sculpt-models');
        // Tasks/Activities
        $this->app->bind('Concore\Personnel\Models\Timeslot','Concore\Sam\Models\Timeslot');
        $this->app->bind('Concore\Personnel\Models\Task','Concore\Sam\Models\Task');
        $this->app->bind('Concore\Personnel\Services\TasksService','Concore\Sam\Services\TasksService');
        $this->app->bind('sculpt-service.activity-service','Concore\Sam\Services\Sculpt\TaskService');
        $this->app->tag('sculpt-service.activity-service','sculpt-services');
        // Events
        $this->app->bind('Concore\Personnel\Handlers\Events\LogRecordCreated','Concore\Sam\Handlers\Events\LogRecordCreated');
        $this->app->bind('Concore\Personnel\Handlers\Events\LogRecordDeleted','Concore\Sam\Handlers\Events\LogRecordDeleted');
        $this->app->bind('Concore\Personnel\Handlers\Events\LogActivePeriodStarted','Concore\Sam\Handlers\Events\LogActivePeriodStarted');
        $this->app->bind('Concore\Personnel\Handlers\Events\LogActivePeriodEnded','Concore\Sam\Handlers\Events\LogActivePeriodEnded');
        // Notes
        $this->app->bind('Concore\Personnel\Models\Note','Concore\Sam\Models\Note');
        // Contacts and Contact Entities
        $this->app->bind('Concore\Personnel\Models\ContactEntity','Concore\Sam\Models\ContactEntity');
        $this->app->bind('Concore\Personnel\Models\Contact','Concore\Sam\Models\Contact');
        // Sexuality
        $this->app->bind('sculpt-model.sexuality','Concore\Sam\Models\Sexuality');
        $this->app->tag('sculpt-model.sexuality','sculpt-models');
        // Accommodation Type
        $this->app->bind('sculpt-model.accommodation_type','Concore\Sam\Models\AccommodationType');
        $this->app->tag('sculpt-model.accommodation_type','sculpt-models');
        // Referral Source
        $this->app->bind('sculpt-model.referral_source','Concore\Sam\Models\ReferralSource');
        $this->app->tag('sculpt-model.referral_source','sculpt-models');
        // Journey Stage
        $this->app->bind('sculpt-model.journey-stage','Concore\Sam\Models\JourneyStage');
        $this->app->tag('sculpt-model.journey-stage','sculpt-models');

        $this->app->bind('Concore\Reports\Http\Controllers\ReportsController','Concore\Sam\Http\Controllers\ReportsController');
        // Service Users Reporting
        $this->app->bind('reports.service_user_cases','Concore\Sam\Reports\ServiceUserCasesReport');
        $this->app->tag('reports.service_user_cases','reports');
        // Advocates Reporting
        $this->app->bind('reports.advocates-volunteer','Concore\Sam\Reports\VolunteerAdvocatesReport');
        $this->app->tag('reports.advocates-volunteer','reports');
        $this->app->bind('reports.advocates-paid','Concore\Sam\Reports\PaidAdvocatesReport');
        $this->app->tag('reports.advocates-paid','reports');
        // Cancer Champions Reporting
        $this->app->bind('reports.cancer-champions','Concore\Sam\Reports\CancerChampionsReport');
        $this->app->tag('reports.cancer-champions','reports');
        // Activities Reporting
        $this->app->bind('reports.activities','Concore\Sam\Reports\ActivitiesReport');
        $this->app->tag('reports.activities','reports');

        // Active Period
        $this->app->bind('Concore\Personnel\Models\ActivePeriod','Concore\Sam\Models\ActivePeriod');

	}

	protected function middleware()
    {
        $this->app->make('router')->middleware('sam_parse_date_input', 'Concore\Sam\Http\Middleware\ParseDateInput');
    }

    protected function config()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../../config/sam.php', 'sam'
        );
        $this->mergeConfigFrom(
            __DIR__.'/../../config/personnel.php', 'personnel'
        );
        $this->mergeConfigFrom(
            __DIR__.'/../../config/sculpt.php', 'sculpt'
        );
    }

    protected function routes()
    {
        include __DIR__.'/../Http/routes.php';
    }

    protected function validation_rules()
    {
        include __DIR__.'/../Http/validation_rules.php';
    }

	protected function composers() 
	{
        View::composer(['sculpt::service-user-cases.index','sculpt::employees.index','sculpt::activities.index'], 'Concore\Sam\Http\ViewComposers\FilterFormComposer');
        View::composer('sculpt::employees.index', 'Concore\Sam\Http\ViewComposers\EmployeeFilterFormComposer');
        View::composer('sculpt::activities.index', 'Concore\Sam\Http\ViewComposers\ActivityFilterFormComposer');
        View::composer('sculpt::service-user-cases.index', 'Concore\Sam\Http\ViewComposers\ServiceUserCaseFilterFormComposer');
        View::composer('sculpt::service-user-cases.partials.forms.form', 'Concore\Sculpt\Http\ViewComposers\AutoForms\FieldsComposer');
        View::composer('sculpt::service-users.partials.forms.form', 'Concore\Sam\Http\ViewComposers\ServiceUserFormComposer');
        View::composer('sculpt::service-user-cases.partials.forms.form', 'Concore\Sam\Http\ViewComposers\ServiceUserCaseFormComposer');
        View::composer(['sculpt::service-user-cases.partials.forms.form','sculpt::activities.partials.forms.form'], 'Concore\Sculpt\Http\ViewComposers\AutoForms\FormComposer');
        View::composer('sculpt::activities.partials.forms.inputs.belongs-to.next-activity', 'Concore\Sculpt\Http\ViewComposers\AutoForms\RelationToOneInlineComposer');
        View::composer('sculpt::activities.partials.forms.form', 'Concore\Sam\Http\ViewComposers\TaskFormComposer');
        View::composer('sculpt::dashboard', 'Concore\Sam\Http\ViewComposers\DashboardComposer');
        View::composer('sculpt::service-user-cases.partials.forms.inputs.belongs-to-many.advocacy-outcomes', 'Concore\Sam\Http\ViewComposers\AdvocacyOutcomesComposer');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

    protected function service_providers()
    {
        $this->app->register('Concore\Personnel\Providers\PersonnelServiceProvider');
        $this->app->register('Concore\Reports\Providers\ReportsServiceProvider');
    }

    private function macros() {
        include __DIR__.'/../../resources/macros.php';
    }

}
