<?php namespace Concore\Sam\Reports;

use Concore\Personnel\Models\Role;
use Concore\Sam\Models\Employee;
use Concore\Sam\Models\Person;
use DB, Carbon\Carbon;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Reports\Traits\ReportableTrait;
use Concore\Reports\Table;
use Concore\Sam\Reports\Interfaces\SamReportableInterface;
use Concore\Sam\Reports\Traits\SamReportableTrait;
use Concore\Sam\Models\Advocate;
use Concore\Sam\Models\ActivePeriod;

class AdvocatesReport extends EmployeesReport {

    protected $role_name = 'advocate';
    protected $role_id = 5;

    public function __construct(Person $person, Employee $employee, ActivePeriod $active_period, Role $role)
    {
        $this->person = $person;
        parent::__construct($employee, $active_period, $role);
    }

    public function getTables() {
        if (!$this->tables) {

//            $tables['start_of_period_table'] = $this->getStartOfPeriodTable();
//            $tables['during_period_table'] = $this->getDuringPeriodTable();
//            $tables['end_of_period_table'] = $this->getEndOfPeriodTable();

            $tables['totals'] = $this->getTotalsTable();
            // Only show this table if we're looking at 1 month, due to server load being too great for more than this
            if($this->from->diffInMonths($this->to) == 0) {
                $tables['breakdown'] = $this->getAdvocateBreakdownTable();
            }
            $tables['gender'] = $this->getGenderTable();
            $tables['ethnicity'] = $this->getEthnicityTable();
            $tables['age'] = $this->getAgeTable();
            $this->tables = $tables;

        }
        return $this->tables;
    }

    public function getAdvocateBreakdownTable() {

        $note_type_ids = config('sam.reporting-advocate-note-types');

        // Construct select statement

        $select = [];
        $select[] = "employees.id as id";
        $select[] = "IF(people.preferred_name IS NOT NULL AND people.preferred_name != '', CONCAT(people.preferred_name, ' ', people.last_name), CONCAT(people.first_name, ' ', people.last_name)) as name";
        foreach($note_type_ids as $id => $label) {
            $select[] = "IF(SUM(IF(notes.note_type_id = $id,1,0)) > 0,'Yes','No') as 'Training received: $label'";
        }
        $select[] = "IF(advocate_service_user_case.service_user_case_id IS NULL, 0, COUNT(DISTINCT advocate_service_user_case.id)) as num_cases";

        $advocates = $this->getBaseQueryBuilder()
            ->selectRaw(implode(', ', $select))
            ->leftJoin('advocate_service_user_case', 'advocate_service_user_case.advocate_id', '=', 'advocates.id')
            ->leftJoin('noteables', function($join) {
                $join->on('noteables.noteable_id', '=', 'people.id')->where('noteables.noteable_type','=',get_class($this->person));
            })
            ->leftJoin('notes', 'noteables.note_id', '=', 'notes.id')
            ->groupBy('id')
            ->get();

        $column_headings = [];
        $column_headings[] = 'Team member ID';
        $column_headings[] = 'Name';
        foreach($note_type_ids as $id => $label) {
            $column_headings[] = "Training Received: $label";
        }
        $column_headings[] = 'Cases';

        return new Table(
            'Breakdown',
            $column_headings,
            $advocates,
            [
                '*' => [
                    0 => function($input) {
                        return '#' . $input; // add # in front of IDs
                    }
                ]
            ],
            function($row_index, $row) {
                return route('sculpt.show', ['employees', $row->id]);
            }
        );

    }

}