<?php namespace Concore\Sam\Reports;

use Concore\Personnel\Models\Role;
use Concore\Sam\Models\Employee;
use DB, Carbon\Carbon;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Reports\Traits\ReportableTrait;
use Concore\Reports\Table;
use Concore\Sam\Reports\Interfaces\SamReportableInterface;
use Concore\Sam\Reports\Traits\SamReportableTrait;
use Concore\Sam\Models\Advocate;
use Concore\Sam\Models\ActivePeriod;

class CancerChampionsReport extends EmployeesReport {

    protected $role_name = 'cancer-champion';
    protected $role_id = 7;
    protected $totals_wording = ['Total cancer champions activated','Total cancer champions added'];

    public function getNameAttribute() {
        return 'Cancer Champions';
    }

    public function applyRoleConstraints($employee) {
        return $employee->join('cancer_champions', 'employees.id', '=', 'cancer_champions.employee_id')
            ->whereNotNull('cancer_champions.id');
    }

}