<?php namespace Concore\Sam\Reports;

use DB;

class PaidAdvocatesReport extends AdvocatesReport {

    protected $totals_wording = ['Total paid advocates activated','Total paid advocated added'];

    public function getNameAttribute() {
        return 'Paid Advocates';
    }

    protected function getBaseUrlArgs() {
        $args = parent::getBaseUrlArgs();
        $args['advocate_type'] = 'Paid';
        return $args;
    }

    public function applyRoleConstraints($employee) {
        return $employee->join('advocates', 'employees.id', '=', 'advocates.employee_id')
            ->where('type_of_advocate', '=', 'Paid');
    }
    
}