<?php namespace Concore\Sam\Services\Sculpt;

use Session, Auth, Carbon\Carbon;
use Concore\Personnel\Services\Sculpt\EmployeeService as ParentClass;

class EmployeeService extends ParentClass {

    public function queryIndex() {
        $query = parent::queryIndex();
        if($input = Session::get('forms.search.employees')) {
            if($this->inputHas($input,'id')) {
                $query->where('id','=',$input['id']);
            }
            if($this->inputHas($input,['organisation_id','name','gender','ethnicity','age'])) {
                $query->whereHas('person',function($query) use($input) {
                    $query->where(function($query) use($input) {
                        if(Auth::user()->can('see:all-organisations') && $this->inputHas($input,'organisation_id')) {
                            $query->whereHas('organisation',function($q) use($input) {
                                $q->where('id','=',$input['organisation_id']);
                            });
                        }
                        if($this->inputHas($input,'name')) {
                            $terms = explode(' ',$input['name']);
                            foreach($terms as $term) {
                                $query->where(function ($query) use ($input, $term) {
                                    $query->where('first_name', 'LIKE', '%' . $term . '%');
                                    $query->orWhere('preferred_name', 'LIKE', '%' . $term . '%');
                                    $query->orWhere('last_name', 'LIKE', '%' . $term . '%');
                                });
                            }
                        }
                        if($this->inputHas($input,'gender')) {
                            if($input['gender'] === 'undefined') {
                                $query->whereNull('gender_id');
                            } else {
                                $query->where('gender_id', '=', $input['gender']);
                            }
                        }
                        if($this->inputHas($input,'ethnicity')) {
                            if($input['ethnicity'] === 'undefined') {
                                $query->whereNull('ethnicity');
                            } else {
                                $query->where('ethnicity', '=', $input['ethnicity']);
                            }
                        }
                        if($this->inputHas($input,'age')) {
                            if($input['age'] === 'undefined') {
                                $query->where(function($query) {
                                    $query->whereNull('age')->orWhere('age','=','0');
                                });
                            } else {
                                list($from,$to) = explode('-',$input['age']);
                                $query->where(function($query) use($from,$to) {
                                    $query->where('age','>=',$from)->where('age','<=',$to);
                                });
                            }
                        }
                    });
                });
            }
            $date_from = empty($input['date_from']) ? null : Carbon::createFromFormat('Y-m-d',$input['date_from'].'-01');
            $date_to = empty($input['date_to']) ? null : Carbon::createFromFormat('Y-m-d',$input['date_to'].'-01');
            if($date_from || $date_to) {
                $query->whereHas('active_periods',function($query) use($date_from, $date_to, $input) {
                    if($date_from) {
                        $query->where('start','>=',$date_from->format('Y-m-d'));
                    }
                    if($date_to) {
                        $query->where('start','<=',$date_to->format('Y-m-t'));
                    }
                    if($this->inputHas($input,'roles')) {
                        $query->whereIn('role_id',$input['roles']);
                    }
                });
            }
            if($this->inputHas($input,'roles')) {
                if($date_from || $date_to) {
                    $query->whereHas('active_periods', function($active_period) use($input, $date_from, $date_to) {
                        $active_period
                            ->whereHas('role', function ($role) use($input, $date_from, $date_to) {
                                $role->whereIn('id', $input['roles']);
                            });
                        if($date_from) {
                            $active_period->where('start','>=',$date_from->format('Y-m-d'));
                        }
                        if($date_to) {
                            $active_period->where('start','<=',$date_to->format('Y-m-t'));
                        }
                    });
                } else {
                    $query->whereHas('user', function($user) use($input) {
                        $user
                            ->whereHas('roles', function ($role) use($input) {
                                $role->whereIn('id', $input['roles']);
                            });
                    });
                }
            }
            if($this->inputHas($input,'advocate_type')) {
                $query->whereHas('advocate',function($query) use($input) {
                    $query->where('type_of_advocate','=',$input['advocate_type']);
                });
                $query->withActivePeriods('advocate',function($active_period) use ($date_from, $date_to) {
                    $active_period->where(function($q) use ($date_from, $date_to) {
                        if($date_from) {
                            $q->where('start','>=',$date_from->format('Y-m-d'));
                        }
                        if($date_to) {
                            $q->where('start','<=',$date_to->format('Y-m-d'));
                        }
                    });
                });
            }
            if(!empty($input['active-only']) && (bool)$input['active-only']) {
                $query->whereHas('active_periods',function($query) {
                    $query->whereNull('end');
                });
            }
        }
        return $query;
    }

    protected function saveRecord($record, $input)
    {
        // Save and attach some relations before saving record
        $this->saveRelations($record,['person','user'], $input);

        // Save record
        if (isset($input[$this->model->getSlugged()])) {
            $record->fill($this->parseInput($input[$this->model->getSlugged()]));
        }
        $record->save();

        // Save and attach some relations after saving record
        $this->saveRelations($record, ['organisation','notes','advocate','cancer_champion'], $input);

        $record->save();

        return $record;
    }

}