<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdvocacyOutcomeServiceUserCaseTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('advocacy_outcome_service_user_case',function(Blueprint $table) {
			$table->integer('advocacy_outcome_id')->unsigned();
			$table->foreign('advocacy_outcome_id')->references('id')->on('advocacy_outcomes')->onDelete('cascade');
			$table->integer('service_user_case_id')->unsigned();
			$table->foreign('service_user_case_id')->references('id')->on('service_user_cases')->onDelete('cascade');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::dropTable('advocacy_outcome_service_user_case');
	}

}
