<?php
Form::macro('date_picker',function($field_name, $current_value, $options) {
    if(is_string($current_value)) {
        $current_value = Carbon\Carbon::createFromTimestamp(strtotime($current_value));
    }
    $now = Carbon\Carbon::now();
    $years = range($now->format('Y'),$now->subYears(130)->format('Y'));
    $months = range(1,12);
    foreach ($months as &$month) {
        $month = sprintf("%02d", $month);
    }
    $days = range(1,31);
    foreach ($days as &$day) {
        $day = sprintf("%02d", $day);
    }
    array_unshift($years,'');
    array_unshift($months,'');
    array_unshift($days,'');
    $years = array_combine($years, $years);
    $months = array_combine($months, $months);
    $days = array_combine($days, $days);
    $old_values = old(str_replace('[','.',str_replace(']','',$field_name)));
    if ($old_values) {
        list($year_old, $month_old, $day_old) = explode('-',$old_values);
        $year_value = $year_old;
        $month_value = $month_old;
        $day_value = $day_old;
    }
    else {
        $year_value = $current_value ? $current_value->format('Y') : '';
        $month_value = $current_value ? $current_value->format('m') : '';
        $day_value = $current_value ? $current_value->format('d') : '';
    }
    if(isset($options['class'])) {
        $options['class'] .= ' not-chosen';
    } else {
        $options['class'] = 'not-chosen';
    }
    $output = '<div class="clearfix row">';
    $output .= '<div class="col-sm-4">'.Form::select($field_name."[date_day]",$days,$day_value,$options).'</div>';
    $output .= '<div class="col-sm-4">'.Form::select($field_name."[date_month]",$months,$month_value,$options).'</div>';
    $output .= '<div class="col-sm-4">'.Form::select($field_name."[date_year]",$years,$year_value,$options).'</div>';
    $output .= '</div>';
    return $output;
});