@extends('reports::partials.tab-content')

@section('report-tab-panel')
    {{--<div class="panel panel-default">
        <div  class="panel-heading">
            <h3 class="panel-title">Progression: <strong>All Cases</strong></h3>
        </div>
        <div class="panel-body">
            @include('reports::partials.tab-content.service-user-cases-report-progression')
        </div>
    </div>--}}
    <div class="case-type-pills">
        <div class="container">
            <ul class="nav nav-pills" role="tablist">
                <li role="presentation" class="active"><a href="#all-cases" aria-controls="home" role="tab" data-toggle="tab">All Cases</a></li>
                <li role="presentation"><a href="#simple-cases" aria-controls="profile" role="tab" data-toggle="tab">Simple Cases</a></li>
                <li role="presentation"><a href="#complex-cases" aria-controls="messages" role="tab" data-toggle="tab">Complex Cases</a></li>
            </ul>
        </div>
    </div>
    <div class="tab-content">
        <div role="tabpanel" class="tab-pane active" id="all-cases">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">General Stats: <strong>All Cases</strong></h3>
                </div>
                <div class="panel-body">
                    <p class="alert alert-info" style="margin-bottom:0;"><strong>All Cases</strong> includes both simple and complex cases.</p>
                    @include('reports::partials.tab-content.service-user-cases-report-general-stats',['include_cases' => 'all'])
                </div>
            </div>
        </div>
        <div role="tabpanel" class="tab-pane" id="simple-cases">
            <div class="panel panel-default">
                <div  class="panel-heading">
                    <h3 class="panel-title">General Stats: <strong>Simple Cases</strong></h3>
                </div>
                <div class="panel-body">
                    <p class="alert alert-info" style="margin-bottom:0;"><strong>Simple Cases</strong> are defined as cases with fewer than 3 advocacy issues.</p>
                    @include('reports::partials.tab-content.service-user-cases-report-general-stats',['include_cases' => 'simple'])
                </div>
            </div>
        </div>
        <div role="tabpanel" class="tab-pane" id="complex-cases">
            <div class="panel panel-default">
                <div  class="panel-heading">
                    <h3 class="panel-title">General Stats: <strong>Complex Cases</strong></h3>
                </div>
                <div class="panel-body">
                    <p class="alert alert-info" style="margin-bottom:0;"><strong>Complex Cases</strong> are defined as cases with 3 or more advocacy issues.</p>
                    @include('reports::partials.tab-content.service-user-cases-report-general-stats',['include_cases' => 'complex'])
                </div>
            </div>
        </div>
    </div>
@stop

@section('head-after-style')
    @parent
    <style>

        h4 {
            background: #d9edf7;
            padding: 15px;
            color: #31708f;
            font-size: 1.8rem;
        }

        .case-type-pills {
            position: fixed;
            bottom: 0;
            right: 0;
            left: 0;
            z-index: 500;
            padding: 5px 0;
            background: rgba(255, 255, 255, 0.8);
            box-shadow: 0 -5px 10px rgba(0, 0, 0, 0.1);
        }

        #start-of-period                    tr td:last-child,
        #during-period                      tr td:last-child,
        #end-of-period                      tr td:last-child {
            width: 50px;
        }

        table[id^=activities] tr:nth-last-child(1),
        table[id^=activities] tr:nth-last-child(2),
        table[id^=activities] tr:nth-last-child(3),
        table[id^=activities] tr:nth-last-child(4),
        table[id^=activities] tr:nth-last-child(5),
        table[id^=activities] tr:nth-last-child(6) {
            font-weight: bold;
        }
        table[id^=totals] tbody tr:nth-of-type(1) td {
            font-weight:bold;
        }
        table[id^=totals]    tr td:last-child,
        table[id^=gender]    tr td:last-child,
        table[id^=ethnicity] tr td:last-child,
        table[id^=sexuality] tr td:last-child,
        table[id^=age]       tr td:last-child,
        table[id^=case-type] tr td:last-child {
            width: 100px;
        }

        table[id^=referral-breakdown] tr td,
        table[id^=referral-breakdown] tr th {
            text-align: left;
        }

    </style>
@stop
