@extends('sculpt!::dashboard')

@section('content')

    {!!  Notification::showAll() !!}

    <h1>Welcome to SAM</h1>

    <div class="modal fade" tabindex="-1" role="dialog" id="welcome-modal" data-modal-number="13">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">SAM Update - 11th January</h4>
                </div>
                <div class="modal-body">
                    <p>Hi,</p>
                    <p>Happy New Year to all SAM users. Information on the most recent update is below. More updates to follow over the next couple of months.</p>
                    <ul>
                        <li>Advocates are now able to add new contacts to cases. They cannot choose from existing contacts in the system, but they can add new contact information.</li>
                        <li>When adding activities to the system, the "Activity outcome" box has been renamed "What happened?" so that there is no confusion between this and advocacy outcomes.</li>
                        <li>On every case page now, there is a breakdown of activity types on the Activities tab for that individual case.</li>
                        <li>When adding a new case or team member, SAM will now notify you if it thinks that person is already in the database. After you've entered a name, SAM will check to see if anyone already exists with that name and if they do, will show a message before you go any further. This will help to prevent duplicate records.</li>
                        <li>Renamed some and cleaned up Journey Stages.</li>
                        <li>Design tweak to the case story activity summary, so that it is more readable when printing.</li>
                        <li>Back button on activity page goes back to whichever page you were on previously as expected, rather than going to the activity list.</li>
                        <li>'Carer' case type has been renamed 'Carer / Friend / Family'.</li>
                        <li>Checkboxes have been added on the Advocacy Outcomes tab on cases to declare whether outcomes are directly from the service user or whether they are an advocate's opinion (e.g. if service user unavailable or passed away).</li>
                        @if(Auth::user()->hasRole(['coordinator','manager']))
                            <li>The cases report now only includes activities during the period rather than all activities for cases added during the period.</li>
                            <li>The activities report now includes any activity made by a particular organisation, rather than any activity for a case that belongs to an organisation.</li>
                            <li>When clicking through to lists of cases from reports, previously this would override your active filters and meant that if you then went back to the cases section your filters will be lost. This has now been changed so filters are not lost when clicking through from reports.</li>
                        @endif
                    </ul>
                </div>
                <div class="modal-footer" style="text-align:left;margin-top:0;">
                    <button type="button" class="btn btn-primary" id="welcome-modal-button" data-dismiss="modal">I have read this update, take me to SAM</button>
                </div>
            </div>
        </div>
    </div>
    @section('body-end')
        @parent
        <script>
            $modal = $('#welcome-modal');
            if(typeof Cookies.get('last-welcome-modal-seen') === 'undefined' || parseInt(Cookies.get('last-welcome-modal-seen')) < parseInt($modal.attr('data-modal-number'))) {
                console.log('test');
                setTimeout(function() {
                    $('#welcome-modal').modal();
                },500);
                $('#welcome-modal-button').on('click', function (e) {
                    Cookies.set('last-welcome-modal-seen',$modal.attr('data-modal-number'), { expires: 365 });
                });
            }
        </script>
    @stop

    @if(count($reminders))
        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title">
                    Reminders
                </h3>
            </div>
            @include('reminders::list',['reminders' => $reminders])
        </div>
    @endif

    @if(count($recent_activities))
        <div class="panel panel-info">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-6" style="margin-top:5px;">
                        <h3 class="panel-title">Recent Activities</h3>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if(Auth::user()->can(['see:activities','see:activities-show']))
                            <a href="{{ route('sculpt.index','activities') }}" class="btn btn-default btn-sm"><i class="fa fa-list"></i> See all activities</a>
                        @endif
                        @if(Auth::user()->can(['see:activities','see:activities-create']))
                            <a href="{{ route('sculpt.create','activities') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New activity</a>
                        @endif
                    </div>
                </div>
            </div>
            @include('sculpt::activities.partials.table',['activities' => $recent_activities])
        </div>
    @endif

    @if(Auth::user()->can('see:all-cases'))

        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title" style="display:inline-block;">
                    <i class="fa fa-fw fa-warning"></i>
                    {{ singular_plural(count($cases_without_advocates),'Unassigned Case','Unassigned Cases') }}
                </h3>
                <span data-toggle="popover" data-trigger="hover" data-content="<p>This shows cases that are open or have yet to be opened with no advocate(s) assigned. Cases that have been open and later closed are not shown, nor are cases with 'No advocate needed' checked.</p><p>This information updates every {{ config('sam.dashboard-cache-time') }} minutes.</p>" class="text-muted">
                    <i class="fa fa-fw fa-info-circle"></i>
                </span>
            </div>
            @if(count($cases_without_advocates))
                @include('sculpt::service-user-cases.partials.table',['cases' => $cases_without_advocates,'classes' => 'table-condensed'])
            @else
                <div class="panel-body">
                    No unassigned cases.
                </div>
            @endif
        </div>

    @endif

    @if(Auth::user()->can('see:employees'))

        <div class="panel panel-info">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-6" style="margin-top:5px;">
                        <h3 class="panel-title" style="display:inline-block;">Caseload</h3>
                        <span data-toggle="popover" data-trigger="hover" data-content="<p>This information updates every {{ config('sam.dashboard-cache-time') }} minutes.</p><p>Average cases per advocate: {{ round($average_cases_per_advocate,0) }}</p>" class="text-muted">
                            <i class="fa fa-fw fa-info-circle"></i>
                        </span>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if(Auth::user()->can(['see:service-user-cases','see:service-user-cases-show']))
                            <a href="{{ route('sculpt.index','service-user-cases') }}" class="btn btn-default btn-sm"><i class="fa fa-list"></i> See all cases</a>
                        @endif
                        @if(Auth::user()->can(['see:service-users','see:service-users-create']))
                            <a href="{{ route('sculpt.create','service-users') }}" class="btn btn-default btn-sm"><i class="fa fa-plus"></i> New service user</a>
                        @endif
                        @if(Auth::user()->can(['see:service-user-cases','see:service-user-cases-create']))
                            <a href="{{ route('sculpt.create','service-user-cases') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New case</a>
                        @endif
                    </div>
                </div>
            </div>
            @if(count($advocates_with_cases))
                <div class="row" style="margin:0;">
                    <?php $i = 1; ?>
                    @foreach($advocates_with_cases as $advocate)
                        <?php $open_cases = $advocate->cases; ?>
                        <div class="col-sm-6" style="padding:0;{!! $i % 2 === 1 ? " clear:both;" : '' !!}">
                            <table class="table" style="margin-bottom:0;">
                                <thead>
                                    <tr>
                                        <th colspan="6">
                                            <a href="{{ $advocate->getUrl() }}" style="color:inherit;">{{ $advocate->name }}</a>
                                            ({{ singular_plural(count($open_cases), 'open case', 'open cases') }})
                                            <?php $days = $advocate->employee->user->daysSinceLastActivity(); ?>
                                            @if($days)
                                                <small data-toggle="tooltip" title="{{ $advocate->employee->person->preferred_name ?: $advocate->employee->person->first_name }}'s last activity was 3 days ago" class="text-muted" style="font-weight:normal; float:right; line-height:1.7;">
                                                    <i class="fa fa-fw fa-calendar-o"></i> {{ $days }} days ago
                                                </small>
                                            @endif
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <?php $j = 1; ?>
                                        @foreach($open_cases as $case)
                                            {!! $j % 2 === 1 ? "</tr><tr>" : '' !!}
                                            <td>
                                                <a href="{{ $case->getUrl() }}" style="color:inherit;"><small>{{ $case->name }}</small></a>
                                            </td>
                                            <td width="2px" align="right" style="padding:0;">
                                                <a style="padding:8px; display:block;" href="{{ route('sculpt.create',['activities','service_user_case_id' => $case->id]) }}" title="New activity for {{ $case->service_user->name }}">
                                                    <small class="text-muted">
                                                        <i class="fa fa-plus"></i>
                                                    </small>
                                                </a>
                                            </td>
                                            <td width="40px" align="right" style="padding-left:0px;">
                                                <?php $days = $case->daysSinceLastActivity(); ?>
                                                @if($days)
                                                    <small class="text-muted" data-toggle="tooltip" title="{{ $case->service_user->person->preferred_name ?: $case->service_user->person->first_name }}'s last activity was {{ $days }} days ago">
                                                        <i class="fa fa-calendar-o" style="margin-right:2px;"></i>
                                                        {{ $days }}
                                                    </small>
                                                @endif
                                            </td>
                                            <?php $j++; ?>
                                        @endforeach
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <?php $i++; ?>
                    @endforeach
                </div>
            @else
                <div class="panel-body">
                    No active advocates with open cases.
                </div>
            @endif
            @if(count($advocates_without_cases))
                <table class="table text-muted">
                    <thead>
                        <tr>
                            <th colspan="4">{{ singular_plural(count($advocates_without_cases),'active advocate','active advocates') }} with no open cases</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <?php $k = 1; ?>
                            @foreach($advocates_without_cases as $advocate)
                                {!! $k % 4 === 1 ? "</tr><tr>" : '' !!}
                                <td width="25%"><a href="{{ $advocate->getUrl() }}" style="color:inherit;">{{ $advocate->name }}</a></td>
                                <?php $k++; ?>
                            @endforeach
                        </tr>
                    </tbody>
                </table>
            @endif
        </div>

    @endif

    @if(Auth::user()->can('see:logged-in-users'))
        @include('sculpt::active-users')
    @endif

    @if(Auth::user()->can('see:all-cases') && AuditLog::has())
        <small class="text-muted">
            @include('auditing::audit-logs-paginated', ['logs'=>AuditLog::paginate(10)])
        </small>
    @endif

@stop