<h1>{{ Config::get('sculpt.site-name') }} Documentation</h1>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-fw fa-star"></i> Essentials</h3>
    </div>
    <ul class="list-group">
        <li class="list-group-item">{!! link_to("$this/basics",'SAM Basics') !!}</li>
        <li class="list-group-item">{!! link_to("$this/finding-information",'Finding information') !!}</li>
        <li class="list-group-item">{!! link_to("$this/support-and-feedback",'Get Support or Provide Feedback') !!}</li>
        <li class="list-group-item">{!! link_to("$this/faq",'Frequently Asked Questions') !!} (FAQs)</li>
    </ul>
</div>

<div class="row">

    <div class="col-sm-6">
        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-fw fa-user"></i> {!! link_to("$this/local-team",'Local Team') !!}</h3>
            </div>
            <ul class="list-group">
                <li class="list-group-item">{!! link_to("$this/local-team",'Local team roles and access rights') !!}</li>
                <li class="list-group-item">{!! link_to("$this/finding-information#_team_member",'Find a particular team member') !!}</li>
                <li class="list-group-item">{!! link_to("$this/local-team/create-activate-deactivate#_create",'Add a new local team member') !!} (e.g. advocate, coordinator)</li>
                <li class="list-group-item">{!! link_to("$this/local-team/create-activate-deactivate#_activate",'Activate a role') !!}</li>
                <li class="list-group-item">{!! link_to("$this/local-team/create-activate-deactivate#_deactivate",'Deactivate a role') !!}</li>
            </ul>
        </div>
    </div>

    <div class="col-sm-6">
        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-fw fa-folder-open"></i> {!! link_to("$this/cases/service-users-and-cases",'Service Users and Cases') !!}</h3>
            </div>
            <ul class="list-group">
                <li class="list-group-item">{!! link_to("$this/service-users-and-cases",'Service Users vs Cases') !!}</li>
                <li class="list-group-item">{!! link_to("$this/finding-information#_case",'Find a particular case') !!}</li>
                <li class="list-group-item">{!! link_to("$this/service-users-and-cases/open-close-reassign#_open",'Opening a new case') !!}</li>
                <li class="list-group-item">{!! link_to("$this/service-users-and-cases/open-close-reassign#_close",'Closing a case') !!}</li>
                <li class="list-group-item">{!! link_to("$this/service-users-and-cases/open-close-reassign#_reassign",'Reassigning a case') !!}</li>
            </ul>
        </div>
    </div>

</div>

<div class="row">

    <div class="col-sm-4">
        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-fw fa-calendar-o"></i> {!! link_to("$this/activities",'Activities') !!}</h3>
            </div>
            <ul class="list-group">
                <li class="list-group-item">{!! link_to("$this/activities",'Add new activity') !!}</li>
                <li class="list-group-item">{!! link_to("$this/finding-information/#_activities_for_case",'Find all activities for a case') !!}</li>
                <li class="list-group-item">{!! link_to("$this/finding-information/#_activities_for_team_member",'Find all activities for a team member') !!} (e.g. advocate, coordinator)</li>
            </ul>
        </div>
    </div>

    <div class="col-sm-4">
        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-fw fa-file-text-o"></i> Contacts and Notes</h3>
            </div>
            <ul class="list-group">
                <li class="list-group-item">{!! link_to("$this/contacts",'Add and remove contacts') !!}</li>
                <li class="list-group-item">{!! link_to("$this/contacts/directory",'Contacts directory') !!}</li>
                <li class="list-group-item">{!! link_to("$this/finding-information#_contact",'Find contact information') !!}</li>
                <li class="list-group-item">{!! link_to("$this/notes",'Add and remove notes') !!}</li>
                <li class="list-group-item">{!! link_to("$this/notes/milestones",'Milestones') !!}</li>
            </ul>
        </div>
    </div>

    <div class="col-sm-4">
        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-fw fa-clock-o"></i> Calendar and Reminders</h3>
            </div>
            <ul class="list-group">
                <li class="list-group-item">{!! link_to("$this/calendar",'Calendar overview') !!}</li>
                <li class="list-group-item">{!! link_to("$this/reminders",'Reminders') !!}</li>
            </ul>
        </div>
    </div>

</div>

<div class="row">
    <div class="col-sm-6">
        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-bar-chart"></i> {!! link_to("$this/reports",'Reports') !!}</h3>
            </div>
            <ul class="list-group">
                <li class="list-group-item">{!! link_to("$this/reports",'Reports overview') !!}</li>
                <li class="list-group-item">{!! link_to("$this/reports#activities",'Activities Report') !!}</li>
                <li class="list-group-item">{!! link_to("$this/reports#cases",'Cases Report') !!}</li>
                <li class="list-group-item">{!! link_to("$this/reports#advocates",'Advocates Report') !!}</li>
            </ul>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title">Other</h3>
            </div>
            <ul class="list-group">
                <li class="list-group-item">{!! link_to("$this/audit-logs",'Audit Logs') !!}</li>
                <li class="list-group-item">{!! link_to("$this/my-account",'My Account') !!}</li>
                <li class="list-group-item">{!! link_to("$this/all",'All documentation') !!}</li>
                <li class="list-group-item">{!! link_to("$this/training-packs",'Training packs') !!}</li>
                <!--<li class="list-group-item">{!! /* @TODO: Organisations */ link_to("$this/organisations",'Organisations') !!}</li>
                <li class="list-group-item">{!! /* @TODO: Independents */ link_to("$this/independents",'Independents') !!}</li>
                <li class="list-group-item">{!! /* @TODO: Lookup Tables */ link_to("$this/lookup-tables",'Lookup Tables') !!}</li>-->
            </ul>
        </div>
    </div>
</div>
