<h1>Opening, Closing and Reassigning Cases</h1>

<div class="panel panel-default screen-only">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-fw fa-list"></i> Contents</h3>
    </div>
    <ul class="list-group">
        <li class="list-group-item"><a href="#_open">Opening a new case</a></li>
        <li class="list-group-item"><a href="#_close">Closing a case</a></li>
        <li class="list-group-item"><a href="#_reassign">Reassigning a case</a></li>
    </ul>
</div>

<section id="_open">

    <h2>Opening a new case</h2>

    <div class="no-break">
        <h4>Step 1 - existing Service User</h4>
        <p>If this is a new case for a service user who has been entered into SAM before, we need to find the service user and enter a new case against them.</p>
    </div>

    <p>Click on the arrow to the right of <strong>Cases</strong> in the main navigation and choose <strong>Service Users</strong>. From here, find the service user in question. Click on the <strong>Cases</strong> tab and click <strong><i class="fa fa-folder-open-o"></i> Open new case</strong>.</p>

    <div class="no-break">
        <h4>Step 1 - new Service User</h4>
        <p>If this is a brand new service user, we need to first create a service user in the system. Click on the arrow to the right of <strong>Cases</strong> in the main navigation and choose <strong><i class="fa fa-plus"></i> New Service User</strong>.</p>
    </div>

    <p>From here, fill out the personal and contact information for the service user. This should be all of the information about the individual themselves rather than the case.</p>

    <p class="alert alert-warning">
        <i class="fa fa-exclamation-triangle"></i> To ensure SAM's database of information is as up to date as possible, please make sure to include all information to hand about the service user, and come back to the record later to fill in any other information once it is learned.
    </p>

    <p>When done, click <strong><i class="fa fa-floppy-o"></i> Add service user</strong> to save changes.</p>

    <p>Once saved, click on the <strong>Cases</strong> tab and click <strong><i class="fa fa-folder-open-o"></i> Open new case</strong>.</p>

    <h4>Step 2</h4>

    <p>We should now enter information about the case itself, such as the reason for referral, advocacy issues and cancer types. See {!! link_to("$this/cases/service-users-and-cases",'Service Users vs Cases') !!} for more information.</p>

    <p>We can also enter the assigned advocate(s) here.</p>

    <p>Click <strong><i class="fa fa-floppy-o"></i> Add case</strong> to save changes.</p>

    <p><strong>Note:</strong> after adding a case, it will remain closed until it has been manually opened. To open a case, click <strong><i class="fa fa-folder-open-o"></i> Open case</strong> on the <strong>Case Status</strong> tab.</p>

</section>

<section id="_close">

    <h2>Closing a Case</h2>

    <p>First, {!! link_to("$docs/finding-information#_case",'find the case page') !!}.</p>

    <p>On the <strong>Case Status</strong> tab click <strong><i class="fa fa-folder-o"></i> Close case</strong>.</p>

    <p>On the next screen we may be asked to provide a reason for closing the case. Choose from the dropdown menu and then click <strong>Deactivate</strong> to save.</p>

    <p>Once we've done this, the case will be closed and we will see a summary of the period that the case was open near the bottom of the <strong>Case Status</strong> tab.</p>

    <p>If we need to declare <strong>Advocacy Outcomes</strong>, this can now be done on the appropriate tab.</p>

    <p class="alert alert-warning">
        <strong>Note:</strong> Advocacy Outcomes can only be entered once a case has been closed.
    </p>

</section>

<section id="_reassign">

    <h2>Reassigning a Case</h2>

    <p>We may need to reassign a case from one advocate to another, or add a second advocate to a case.</p>

    <p>Click on <strong>Cases</strong> in the main navigation. From here, find a case by browsing the pages or {!! link_to("$docs/finding-information#_filtering",'filtering') !!}.</p>

    <p>We can manage which advocates are assigned to the case on the <strong>Case Status</strong> tab under <strong>Advocates</strong>. Click inside the box and choose an advocate (remember, we can type in this box to filter results), or click the <strong><i class="fa fa-times"></i></strong> symbol to remove an advocate. Once done, click <strong><i class="fa fa-floppy-o"></i> Update case</strong> to save.</p>

</section>