@section('form')
    <div class="tab active" data-tab-title="Main">
        @include(Sculpt::getView('partials.forms.relation'),['relation' => 'person'])
    </div>
@stop

@section('body-end')
    @parent
    @include('sculpt::partials.check-exists')
@stop

@section('tabs')
    <div class="tab" data-tab-title="Team Member Details">
        @if($record->id)
            @include('sculpt::users.partials.forms.role-info')
        @else
            <p class="alert alert-warning">
                You can assign roles to this independent (e.g. advocate, coordinator) on the next screen.
            </p>
        @endif
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Team Member Details</h3>
            </div>
            <div class="panel-body">
                @include(Sculpt::getView('partials.forms.fields'))
            </div>
        </div>
    </div>
    @if($record->id && $record->advocate)
        <div class='tab' data-tab-title='Cases'>
            <h3>Cases</h3>
            @include('sculpt::service-user-cases.partials.table',['cases' => $record->advocate->cases])
            @if(Auth::user()->can(['see:service-user-cases', 'see:service-user-cases-create']))
                <div class="form-group">
                    <a href="{{ route('sculpt.create','service-user-cases') }}" class="btn btn-default"><i class="fa fa-fw fa-folder-open-o"></i> Open new case</a>
                </div>
            @section('sidebar-buttons')
                <a href="{{ route('sculpt.create','service-user-cases') }}" class="btn btn-default btn-block"><i class="fa fa-fw fa-folder-open-o"></i> Open new case</a>
            @stop
            @endif
        </div>
    @endif
    @if($record->id)
        <div class="tab" data-tab-title="Activities">
            <h3>Activities</h3>
            @if(count($record->activities_created) || count($record->activities))
                <table class="table" style="margin-bottom:0;">
                    <thead>
                        <th>{{ Sculpt::getTrans('field-labels.activities_number') }}</th>
                        <th>{{ Sculpt::getTrans('field-labels.activities_average_duration') }}</th>
                        <th>{{ Sculpt::getTrans('field-labels.activities_duration') }}</th>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ count($record->activities_created) + count($record->activities) }}</td>
                            <td>{{ floor($record->activities_average_duration / 60) . ':' . sprintf('%02d',ceil($record->activities_average_duration % 60)) }}</td>
                            <td>{{ floor($record->activities_duration / 60) . ':' . sprintf('%02d',ceil($record->activities_duration % 60)) }}</td>
                        </tr>
                    </tbody>
                </table>
            @endif
            @if(Auth::user()->can(['see:employees','see:employees-update']))
                <div class="form-group">
                    <a href="{{ route('sculpt.create',['activities']) }}" class="btn btn-default">{!! Config::get('sculpt.icon-task') !!} New activity</a>
                </div>
            @endif
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Undertaken by
                        @if (Auth::user()->can('see:identifying-information'))
                            {{ $record->person->preferred_name ?: $record->person->first_name }}
                        @else
                            {{ $record->getHumanReadable().' #'.$record->id }}
                        @endif
                    </h3>
                </div>
                <div class="panel-body">
                    <p>These activities were undertaken by
                        @if (Auth::user()->can('see:identifying-information'))
                            {{ $record->person->preferred_name ?: $record->person->first_name }}
                        @else
                            {{ $record->getHumanReadable().' #'.$record->id }}
                        @endif
                        (or another user on their behalf).
                    </p>
                    @include('sculpt::activities.partials.table',['activities' => $record->activities_created])
                </div>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">
                        @if (Auth::user()->can('see:identifying-information'))
                            {{ $record->person->preferred_name ?: $record->person->first_name }}
                        @else
                            {{ $record->getHumanReadable().' #'.$record->id }}
                        @endif
                        was present
                    </h3>
                </div>
                <div class="panel-body">
                    <p>These activities were undertaken by another user, but
                        @if (Auth::user()->can('see:identifying-information'))
                            {{ $record->person->preferred_name ?: $record->person->first_name }}
                        @else
                            {{ $record->getHumanReadable().' #'.$record->id }}
                        @endif
                        was declared as being present.
                    </p>
                    @include('sculpt::activities.partials.table',['activities' => $record->activities])
                </div>
            </div>
        </div>
    @endif
    @if($record->user && Auth::user()->can('see-route:audit.feed'))
        <div class="tab" data-tab-title="Audit Log">
            @include('auditing::audit-logs-paginated', ['logs'=>AuditLog::forLoggeePaginated($record, 10),'loggee'=>$record])
        </div>
    @endif
@stop

@section('sidebar-buttons')
    @parent
    @if($record->id)
        <a href="{{ route('sam.service-users.from-person', ['model_type' => 'service-users', 'person' => $record->person->id]) }}" class="btn btn-default btn-block"><i class="fa fa-fw fa-plus-circle"></i> Add as service user</a>
    @endif
@stop