<script>
    $(document).ready(function() {
        var $first_name_input = $(':input[name="person[0][person][first_name]"]');
        var $last_name_input = $(':input[name="person[0][person][last_name]"]');

        if ($first_name_input.length && $last_name_input.length) {
            $first_name_input.keyup(function () {
                $('.alert-check-exists').remove();
                var $this = $(this);
                delay(function () {
                    var first_name =  $first_name_input.val();
                    var last_name = $last_name_input.val();
                    if(first_name.length >= 2 && last_name.length >= 2) {
                        checkExists($this, first_name, last_name);
                    }
                }, 400);
            });

            $last_name_input.keyup(function () {
                $('.alert-check-exists').remove();
                var $this = $(this);
                delay(function () {
                    var first_name =  $first_name_input.val();
                    var last_name = $last_name_input.val();
                    if(first_name.length >= 2 && last_name.length >= 2) {
                        checkExists($this, first_name, last_name);
                    }
                }, 400);
            });
        }
    });

    function checkExists(input, first_name, last_name) {
        console.log('posting');
        $.ajax({
            type: 'POST',
            url: window.location.href.replace('/new', '/check-exists'),
            data: {
                first_name: first_name,
                last_name: last_name,
                _token: "{{csrf_token()}}"
            }
        }).done(function(data) {
            if (data) {
                $('<div />')
                    .addClass('alert alert-warning alert-check-exists')
                    .attr('style', 'margin-left: 15px; margin-right: 15px; clear: both;')
                    .html('<i class="fa fa-exclamation-triangle"></i> <strong>Warning:</strong> {{ Sculpt::getTrans('validation-warning') }} <a href="' + window.location.href.replace('/new', '/' + data.id) + '" target="_blank">here</a>')
                    .appendTo(input.closest('.row'));;
            }
        });
    }

    var delay = (function () {
        var timer = 0;
        return function (callback, ms) {
            clearTimeout(timer);
            timer = setTimeout(callback, ms);
        };
    })();
</script>