@extends('sculpt::service-user-cases.index')

@section('locations')
    @foreach ($records as $case)
        @if($case->address && $case->address->latitude && $case->address->longitude)
            {
                "Place":{
                    "index":"{{ $case->id }}",
                    "name":"{{ $case->name }}",
                    @if($case->isActive())
                        "class":"text-success",
                        "case_icon":"<i class='fa fa-fw fa-folder-open-o'></i>",
                    @else
                        "class":"text-warning",
                        "case_icon":"<i class='fa fa-fw fa-folder-o'></i>",
                    @endif
                    "address":"{!! implode("<br />",$case->address->toArray()) !!}",
                    "url":"{{ $case->getUrl() }}",
                    "lat":"{{ $case->address->latitude }}",
                    "lng":"{{ $case->address->longitude }}"
                }
            },
        @endif
    @endforeach
@stop

@section('info-window')
    markerContent += "<div class='location_popup'>";
        markerContent += "<h5><a href='" + place.url + "' class='" + place.class + "'>" + place.case_icon + " " + place.name + "</a></h5>";
        markerContent += "<address>" + place.address + "</address>";
    markerContent += "</div>";
@stop

@section('table')
    @include('geo::partials.map', ['locations' => $records])
@stop

@section('pagination')
@stop

@section('body-end')
    <script>
        window.googleMapSettings = {
            infoWindow: true
        }
    </script>
    @parent
@stop