<?php $currently_active = $record->active_periods()->active()->first() ?: null; ?>

<div class="panel {{ $currently_active ? 'panel-success' : 'panel-warning' }}">
    <div class="panel-heading">
        @if($currently_active)
            <h3 class="panel-title"><i class="fa fa-fw fa-folder-open-o"></i> Open Case</h3>
        @else
            <h3 class="panel-title"><i class="fa fa-fw fa-folder-o"></i> Closed Case</h3>
        @endif
    </div>
    <div class="panel-body" style="padding-bottom:0;">
        @if($record->id)
            @if(Auth::user()->can('do:change-case-service-user'))
                @include(Sculpt::getView('partials.forms.relation'),['relation'=>'service_user'])
                <p style="margin-bottom:15px;">
                    <a href="{{ route('sculpt.show',['service-users',$record->service_user_id]) }}">Service user details <i class="fa fa-angle-right"></i></a>
                </p>
            @else
                <div class="form-group">
                    <label class="control-label">Service user:</label>
                    <a href="{{ route('sculpt.show',['service-users',$record->service_user_id]) }}">{{ $record->service_user->name }}</a>
                    <input type="hidden" name="service-user-case[service_user_id]" value="{{ $record->service_user_id }}" />
                </div>
            @endif
            <div class="form-group">
                <label class="control-label">Status:</label>
                @if($currently_active)
                    Open since {{ $currently_active->start->format('jS F Y') }}
                    @if(Auth::user()->can('do:close-case'))
                        <a href="{{ route('active-periods.end',[$currently_active->id,'redirect' => URL::current() . '#tab-2']) }}"><i class="fa fa-fw fa-folder-o"></i> Close case</a>
                    @endif
                @elseif(!$record->active_periods()->inactive()->count())
                    Never been opened
                    @if(Auth::user()->can('do:open-case'))
                        <a href="{{ route('active-periods.start',[get_class($record), $record->id, $service_user_case_role_id]) }}"><i class="fa fa-fw fa-folder-open-o"></i> Open case</a>
                    @endif
                @else
                    Closed since {{ $record->active_periods()->orderBy('end','desc')->first()->end->format('jS F Y') }}
                    @if(Auth::user()->can('do:open-case'))
                        <a href="{{ route('active-periods.start',[get_class($record), $record->id, $service_user_case_role_id]) }}"><i class="fa fa-fw fa-folder-open-o"></i> Reopen case</a>
                    @endif
                @endif
            </div>
        @else
            @include(Sculpt::getView('partials.forms.relation'),['relation'=>'service_user'])
        @endif
        @if(Auth::user()->can('do:change-case-advocates'))
            @include(Sculpt::getView('partials.forms.relation'),['relation'=>'advocates'])
            @include(Sculpt::getView('partials.forms.field'),['field'=>'no_advocate_needed'])
        @endif
        @if(Auth::user()->can('see:identifying-information'))
            @include(Sculpt::getView('partials.forms.field'),['field'=>'brief_reason_for_referral'])
            <p class="alert alert-warning" style="display:none;">
                <i class="fa fa-fw fa-exclamation-triangle"></i>
                Not all of the text could be entered into the field, so some has been cut off at the end.
            </p>
        @endif
    </div>

    @if($record->everActive())
        @include(Sculpt::getView('partials.forms.active-periods-table'))
    @endif
</div>

@section('body-end')
    @parent
    <script>
        $("textarea[name*='brief_reason_for_referral']").on('keyup paste', function() {
            var $p = $(this).parent().next();
            // We need the replace to ensure Chrome counts \r\n as two characters, bug in Chrome
            // see http://stackoverflow.com/questions/10030921/chrome-counts-characters-wrong-in-textarea-with-maxlength-attribute
            if($(this).val().replace(/(\r\n|\n|\r)/g, '--').length == parseInt($(this).attr('maxlength'))) {
                $p.show();
            } else {
                $p.hide();
            }
        });
    </script>
@stop