<?php namespace Concore\Sam\Handlers\Events;

use Concore\Personnel\Handlers\Events\LogRecordCreated as ParentClass;
use Concore\Sculpt\Events\RecordCreated;

class LogRecordCreated extends ParentClass {

    /**
     * Handle the event.
     *
     * @param  RecordCreated  $event
     * @return void
     */
    public function handle(RecordCreated $event)
    {
        if ($this->is_logged($event->record,'create')
            && $this->is_of_type($event->record,'\Concore\Sam\Models\Task')) {
            $case = $event->record->service_user_case ? $event->record->service_user_case->name : null;
            $this->audit_log_service->put('create-activity-record',$event->record, compact('case'));
        }
        elseif ($this->is_logged($event->record,'create')
            && $this->is_of_type($event->record,'\Concore\Sam\Models\ServiceUserCase')) {
            $this->audit_log_service->put('create-record',$event->record);
            $advocates = $event->record->advocates;
            if ($advocates) {
                $advocates_array = [];
                foreach($advocates as $advocate) {
                    $advocates_array[] = $advocate->name;
                    $this->audit_log_service->put('added-advocate',$advocate,['case'=>$event->record->name]);
                }
                $advocates = $advocates_array;
                $this->audit_log_service->put('changed-advocates',$event->record, ['added'=>$advocates]);
            }
            $this->logNotes($event->record);
        }
        elseif ($this->is_logged($event->record,'create')
            && $this->is_of_type($event->record,'\Concore\Sam\Models\ServiceUser')) {
            $this->audit_log_service->put('create-record',$event->record);
            $this->logNotes($event->record);
        }
        else {
            parent::handle($event);
        }
    }

}