<?php namespace Concore\Sam\Http\Controllers\Sculpt;

use Input, Session, View, URL;

class SculptModelController extends \Concore\Sculpt\Http\Controllers\SculptModelController {

    protected function setInput() {
        // Only save filters if they've been set from this page, not if we've been linked to a certain set of results from another page
        if(URL::previous() === URL::current()) {
            // Check for filter form input and set in session
            if(Input::has('clear')) {
                Session::forget('forms.search.' . $this->sculpt_model_service->model->getSluggedPlural());
            } else if(count(Input::except('_token'))) {
                Session::put('forms.search.' . $this->sculpt_model_service->model->getSluggedPlural(), Input::except('_token'));
            }
        }
        if(count(Input::except('_token'))) {
            View::share('filters',Input::except('_token'),[]);
        } else {
            View::share('filters',Session::get('forms.search.' . $this->sculpt_model_service->model->getSluggedPlural(),[]));
        }
    }

}