<?php namespace Concore\Sam\Http\Controllers\Sculpt;

use Concore\Sam\Models\ServiceUserCase;

class ServiceUserCaseController extends SculptModelController {

    public function map() {
        $this->setInput();

        $records = $this->sculpt_model_service->queryIndex()->whereHas('service_user',function($query) {
            $query->whereHas('person',function($q) {
                $q->whereHas('contact', function ($q) {
                    $q->has('addresses');
                });
            });
        })->get();

        $all_records = null;
        if($list = $this->sculpt_model_service->getAllRecords()) {
            $all_records = ['' => ''];
            foreach($list as $id => $name) {
                $all_records[$id] = $name;
            }
        }

        $can_reorder = $this->sculpt_model_service->canReorder();
        $can_create = $this->sculpt_model_service->canCreate();

        return view('sculpt::service-user-cases.map')->with(compact('records','all_records','can_reorder','can_create'));
    }

    public function story(ServiceUserCase $case, $table, $id) {
        $case = $case->find($id);
        return view('sculpt::service-user-cases.story')->with('case', $case);
    }

}

