<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Personnel\Models\Nature;
use Input, Session, Auth;
use Illuminate\Contracts\View\View;

class TaskFormComposer {

    /**
     * @var NatureGroup
     */
    private $nature;

    public function __construct(Nature $nature) {
        $this->nature = $nature;
    }

    public function compose(View $view) {
        $view_data = $view->getData();
        $task = $view_data['record'];
        $person_id_by_su_case_id = $person_id_by_user_id = $cases_first_advocate_user_id = [];
        // Get map of service user IDs, user IDs and person IDs
        // @TODO: Optimise this, currently doing all() because using getServiceUserCaseRelationChoices()
        $su_cases = $task->getServiceUserCaseRelationChoices();
        foreach($su_cases as $case) {
            $person_id_by_su_case_id[$case->id] = $case->service_user->person_id;
            if($case->advocates()->count() && $employee = $case->advocates->first()->employee) {
                $cases_first_advocate_user_id[$case->id] = $employee->user_id;
            }
        }
        $users = $task->getUserRelationChoices();
        foreach($users as $user) {
            if ($user->employee) {
                $person_id_by_user_id[$user->id] = $user->employee->person_id;
            }
        }
        $natures = ['' => ''];
        $nature_visibility = $nature_classes = [];
        foreach($this->nature->all() as $nature) {
            if(strpos($nature->name,': ')) {
                list($group,$name) = explode(': ',$nature->name);
                if(!isset($natures[$group])) {
                    $natures[$group] = [];
                }
                $natures[$group][$nature->id] = $name;
            } else {
                $natures[$nature->id] = $nature->name;
            }
            $nature_visibility[$nature->id] = $nature->type;
            $nature_classes[$nature->id] = $nature->type === 'both' ? 'advocate case' : $nature->type;
        }
        $next_activity = $task->getNextActivityByCase();
        $prev_activity = $task->getPrevActivityByCase();
        $view->with(compact('person_id_by_su_case_id','person_id_by_user_id','cases_first_advocate_user_id','natures','nature_visibility','nature_classes','next_activity','prev_activity'));
    }

}