<?php namespace Concore\Sam\Models;

class Employee extends \Concore\Personnel\Models\Employee {

    public $relation_methods = ['active_periods','person', 'user','advocate','cancer_champion'];

    public function advocate() {
        return $this->hasOne(app('Concore\Sam\Models\Advocate'));
    }

    public function cancer_champion() {
        return $this->hasOne(app('Concore\Sam\Models\CancerChampion'));
    }
    
    public function getActivitiesAttribute() {
        if ($this->person) {
            return $this->person->activities;
        }
        return null;
    }

    public function getActivitiesCreatedAttribute() {
        if ($this->user) {
            return $this->user->tasks_created;
        }
        return null;
    }

    public function getActivitiesDurationAttribute() {
        $present = $created = 0;
        if ($this->activities_created) {
            $created = $this->activities_created->map(function($activity) {
                return $activity->duration;
            })->sum();
        }
        return $present + $created;
    }

    public function getActivitiesAverageDurationAttribute() {
        return ($this->activities->count() > 0 || $this->activities_created->count() > 0) ? $this->activities_duration / ($this->activities->count() + $this->activities_created->count()) : 0;
    }

    public function scopeWithActivePeriods($query, $role_name, $callback = null, $operator = '>=', $num = 1) {
        return $query->whereHas('active_periods', function($active_period) use($callback, $role_name, $operator, $num) {
            $active_period
                ->whereHas('role', function ($role) use($role_name) {
                    $role->where('name', '=', $role_name);
                });
            if($callback) {
                $active_period = $callback($active_period);
            }
        },$operator,$num);
    }

    public function scopeSelectAgeGroups($query) {
        $query_string = "SUM(CASE WHEN people.age IS NULL OR people.age = 0 THEN 1 ELSE 0 END) as 'Undefined'";
        foreach(config('sam.reporting-age-groups') as $age_group) {
            list($from,$to) = explode('-',$age_group);
            $query_string .= ", SUM(IF(people.age BETWEEN $from AND $to,1,0)) as '$age_group'";
        }
        return $query->selectRaw($query_string)->join('people', 'employees.person_id', '=', 'people.id');
    }

}
