<?php namespace Concore\Sam\Reports;

use DB;

class VolunteerAdvocatesReport extends AdvocatesReport {

    protected $totals_wording = ['Total volunteer advocates activated','Total volunteer advocates added','Total hours support provided','Average hours support provided'];

    public function getNameAttribute() {
        return 'Volunteer Advocates';
    }

    protected function getBaseUrlArgs() {
        $args = parent::getBaseUrlArgs();
        $args['advocate_type'] = 'Volunteer';
        return $args;
    }

    public function applyRoleConstraints($employee) {
        return $employee->join('advocates', 'employees.id', '=', 'advocates.employee_id')
            ->where('type_of_advocate', '=', 'Volunteer');
    }
    
}