<?php namespace Concore\Sam\Services\Sculpt;

use Session, AuditLog, Auth, Input;
use Concore\Sculpt\Services\SculptModelService;

class ServiceUserService extends SculptModelService {

    public function queryIndex() {
        // Get in alphabetical order by person first name
        $query = $this->model->select(['service_users.*'])->join('people','service_users.person_id','=','people.id')->orderBy('people.last_name','asc');
        $user = Auth::user();
        if(!$user->can('see:all-organisations')) {
            $query = $query->inOrganisation($user->getOrganisationId());
        }
        if($user->hasRole('advocate') && $user->can('see:own-cases') && !$user->can('see:all-cases')) {
            $query = $query->whereHas('cases',function($query) use($user) {
                $query->forAdvocate($user->employee->advocate->id);
            });
        }

        if(count(Input::except('_token'))) {
            $input = Input::except('_token');
        } else {
            $input = Session::get('forms.search.service-users');
        }
        if ($input) {
            if ($this->inputHas($input,'case_id')) {
                $query->whereHas('cases', function ($query) use ($input) {
                    $query->where('id', $input['case_id']);
                });
            }
            if ($this->inputHas($input,'name')) {
                $query->whereHas('person', function($query) use($input) {
                    $terms = explode(' ', $input['name']);
                    foreach($terms as $term) {
                        $query->where(function ($query) use ($input, $term) {
                            $query->where('first_name', 'LIKE', '%' . $term . '%');
                            $query->orWhere('preferred_name', 'LIKE', '%' . $term . '%');
                            $query->orWhere('last_name', 'LIKE', '%' . $term . '%');
                        });
                    }
                });
            }
        }

        return $query;
    }

    protected function saveRecord($record, $input)
    {
        // Save and attach relations before saving record
        $this->saveRelations($record, $record->relation_methods, $input);

        // Save record
        if (isset($input[$this->model->getSlugged()])) {
            $record->fill($this->parseInput($input[$this->model->getSlugged()]));
        }
        $record->save();

        return $record;
    }

    public function updateRecord($id, $input) {
        $this->setRecord($id);
        $service_user = $this->queryUpdate($id)->first();

        $notes_already_present = [];

        if ($service_user->notes) {
            foreach($service_user->notes as $note) {
                $notes_already_present[] = $note->id;
            }
        }

        // Save record
        $service_user = $this->saveRecord($service_user, $input);

        $new_notes = $service_user->notes()->whereNotIn('note_id',$notes_already_present)->get();

        if ($new_notes) {
            foreach($new_notes as $new_note) {
                AuditLog::put('added-note',$service_user);
            }
        }

        return $service_user;
    }

    protected function getCheckExistingQuery($model, $input) {
        return $model->whereHas('person', function ($query) use ($input) {
            if (!empty($input['first_name'])) {
                $query->where('first_name', 'like', '%' . $input['first_name'] . '%');
            }
            if (!empty($input['last_name'])) {
                $query->where('last_name', 'like', '%' . $input['last_name'] . '%');
            }
        })->first();
    }

}