<?php namespace Concore\Services\Providers;

use View;
use Illuminate\Support\ServiceProvider;
use Concore\Foundation\Providers\Traits\ExplicitViewLoaderTrait;

class ServicesServiceProvider extends ServiceProvider
{

    use ExplicitViewLoaderTrait;

    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->routes();
        $this->config();
    }

    /**
     * Load utility functions, custom exceptions, view composers, form macros, custom validators.
     * Register facades, service providers and aliases.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadViewsFrom(__DIR__ . '/../../resources/views/', 'services');

        $this->app->bind('sculpt-model.service','Concore\Services\Models\Service');
        $this->app->tag('sculpt-model.service','sculpt-models');
        if(config('services.include-in-sitemap')) {
            $this->app->tag('Concore\Services\Models\Service','in-sitemap');
        }

        View::composer('services::partials.grid', 'Concore\Services\Http\ViewComposers\ServicesGridComposer');

        // Publishes
//        $this->publishes([
//            __DIR__ . '/../../resources/views/' => base_path('resources/views/vendor/pages'),
//        ], 'views');
//        $this->publishes([
//            __DIR__ . '/../../migrations/' => $this->app->databasePath() . '/migrations'
//        ], 'migrations');
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return array();
    }

    protected function routes() {
        include __DIR__.'/../Http/routes.php';
    }

    protected function config() {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/services.php', 'services'
        );
    }

}