<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateServicesTable extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services',function(Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('key');
            $table->text('intro')->nullable();
            $table->integer('image_id')->nullable()->default(null)->unsigned();
            $table->foreign('image_id')->references('id')->on('media');
            $table->integer('parent_id')->nullable()->default(null)->unsigned();
            $table->foreign('parent_id')->references('id')->on('services');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('services');
    }

}
