<?php namespace Concore\Services\Models;

use Concore\Content\Models\Traits\HasContentTrait;
use Concore\Foundation\Models\Interfaces\IdentifiableInterface;
use Concore\Foundation\Models\Traits\HasKeyTrait;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Illuminate\Database\Eloquent\Model;

class Service extends Model implements IdentifiableInterface {

    use HasContentTrait,
        IdentifiableTrait,
        HasKeyTrait;

    public $relation_methods = ['image','parent','content','content_text','content_text_and_image','content_banner'];

    public $fillable = ['name','key', 'image_id'];

    public function parent() {
        return $this->belongsTo(new static(),'parent_id');
    }

    public function children() {
        return $this->hasMany(new static(),'parent_id');
    }

    public function image() {
        return $this->belongsTo(app('Concore\Foundation\Models\Media'));
    }

}