<?php namespace Concore\Services\Http\Controllers;

use Concore\Services\Models\Service;
use Notification, Redirect;

class ServicesController extends \Illuminate\Routing\Controller {

    public function show(Service $service, $key) {
        $service = $service->find($key);

        if(!$service) {
            if(config('foundation.redirect_removed_content')) {
                Notification::info('This service could not be found and has likely been removed.');
                return Redirect::to('/',[],301);
            } else {
                return app()->abort(404);
            }
        }

        return view('services::show')->with('service',$service);
    }
}
