<?php namespace Concore\Services\Http\ViewComposers;

use Concore\Services\Models\Service;
use Illuminate\Contracts\View\View;

class ServicesGridComposer {
    public function __construct(Service $service) {
        $this->service = $service;
    }
    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $view_data = $view->getData();
        if(!isset($view_data['services'])) {
            $services = $this->service->orderBy('created_at', 'asc')->get();
            $view->with(compact('services'));
        }
    }

}