<?php namespace Concore\Subscriptions\Services;

use Concore\Subscriptions\Models\Subscriber;

class SubscriptionService {

	public function __construct(Subscriber $subscriber) {
		$this->subscriber = $subscriber;
	}

	protected function getSubscriber($email) {
		return $this->subscriber->where('email','=',$email)->get();
	}

	public function isSubscribed($email) {
		$subscriber = $this->getSubscriber($email);
		return $subscriber->count() > 0 ? $subscriber : false;
	}

	public function addSubscriber($name, $email) {
		if($subscriber = $this->isSubscribed($email)) {
			return true;
		} else {
			return $this->subscriber->create([
				'name' => $name,
				'email' => $email
			]);
		}
	}

	public function removeSubscriber($email) {
		if(!($subscriber = $this->isSubscribed($email))) {
			return true;
		} else {
			return $this->subscriber->destroy(array_pluck($subscriber,'id'));
		}
	}

	// This returns a LaravelExcelWriter object which supports csv or xls download
	// See http://www.maatwebsite.nl/laravel-excel/docs/export#export
	// Use like so: $subscription_service->exportSubscribers()->download('xls')
	public function exportSubscribers() {
		$excel = app('excel');
		$subscriber = $this->subscriber;
		return $excel->create('subscribers', function($excel) use($subscriber) {
		    $excel->sheet('Subscribers', function($sheet) use($subscriber) {
		    	$headings = [['Name','Email','Date subscribed']];
		    	$data = array_merge($headings,$subscriber->select('name','email','created_at')->get()->toArray());
		    	$sheet->fromArray($data,null,'A1',false,false);
		    });
		});
	}

}