<?php namespace Concore\Subscriptions\Http\Controllers;

use Input, Redirect;
use Concore\Subscriptions\Services\SubscriptionService;

class SubscriptionsController extends \Illuminate\Routing\Controller {
	public function addSubscriber(SubscriptionService $subscription_service) {
        $email = Input::get('email');
        if(Input::has('name')) {
            $name = Input::get('name');
            $subscription_service->addSubscriber($email, $name);
        }
        else {
            $subscription_service->addSubscriber($email);
        }
        Notification::success(trans('Thank you for signing up to our newsletter.'));
		return Redirect::back();
	}
	public function removeSubscriber(SubscriptionService $subscription_service, $email) {
		$subscription_service->removeSubscriber($email);
		return Redirect::back();
	}
}