<?php namespace Concore\Subscriptions\Providers;

use Illuminate\Support\ServiceProvider;

class SubscriptionsServiceProvider extends ServiceProvider {

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
        $this->config();
        $this->bindings();
		$this->routes();
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{
        $this->loadViewsFrom(__DIR__.'/../../resources/views/', 'subscriptions');
        $this->publishes([
            __DIR__.'/../../resources/views/' => base_path('resources/views/vendor/subscriptions'),
        ], 'views');

        // Can override Sculpt package's views
        $this->app['view']->addNamespace('sculpt',__DIR__.'/../../resources/views/vendor/sculpt');
	}

    public function bindings() {
        $this->app->bind('sculpt-read-only-model.subscriber','Concore\Subscriptions\Models\Subscriber');
        $this->app->tag('sculpt-read-only-model.subscriber','sculpt-read-only-models');
    }

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

	protected function routes()
	{
		include __DIR__.'/../Http/routes.php';
	}

    protected function config()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/subscriptions.php', 'subscriptions'
        );
    }
}
